#!/usr/bin/python

# CCSM h0 file concatenator

# 2008/08/22 C. Fischer

# Changes:
# 2008/08/27 CAF  Added check to see if files exist, if they do then don't process
# 2008-08-18 CAF  added climo directory
# 2008-08-19 CAF  added check for climo files and CF converted files
# 2008-12-01 CAF  replaced system call with popen, add error checking
# 2009-01-27 CAF  Change climo dir structure
# 2009-03-11 CAF  Fixed bug with file checking
# 2009-06-11 CAF  Added date range to output filename

# Dependencies: python-numpy, python-scientific, NCO

# Known issues:
# Only handles h0(monthly mean) files from CCSM

# What it does:
#  - Concatenates a single variable from several different h0(monthly mean) files into one netcdf
#    file. 

from os import  environ,system,popen
from sys import exit
#CAF import numpy
#CAF from Scientific.IO import NetCDF
import re
#CAF from sets import Set
import os
from os.path import isfile,isdir

def ccsm(m,namelist,variable,fld,debug=0):
  ierror=0
# If model is CCSM (CAM,WACCM) then we need to convert some variable names to
# CF variable names  U -> ua  T -> ta
# Open text file that has list of variables that need to be converted.
  climo_dir=namelist.global_vars.climo_dir
  project_name=namelist.global_vars.project
  environ["FIELD_NUMBER_REQ"]=fld
  old_variable = variable
#
# Create field numbers for climo file check
#
  CCMVal_field_m=fld.replace("T","C")
  CCMVal_field_s=fld.replace("T","C")
  CCMVal_field_a=fld.replace("T","C")
  CCMVal_field_s=CCMVal_field_s.replace("M","S")
  CCMVal_field_a=CCMVal_field_a.replace("M","A")
  CCMVal_field_s=CCMVal_field_s.replace("D","S")
  CCMVal_field_a=CCMVal_field_a.replace("D","A")
  CCMVal_field_s=CCMVal_field_s.replace("I","S")
  CCMVal_field_a=CCMVal_field_a.replace("I","A")

  f=open('./reformat/ccsm_convert.txt')
  for line in f:
    line=line.replace("\n", "")
    b=line.split(',')
    if (b[0] == variable):
     old_variable=b[len(b)-1]
     break
# Determine the CCMVal_field
  fld=fld.replace("C","T")
  CCMVal_field=fld
# Concatenate model data into one time series file
 
#
# Check to see if CF converted file exists
#
  outfile=namelist.global_vars.project+'_'+m.case+'_'+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+".nc"
  if not isfile(namelist.global_vars.climo_dir+"/"+m.case+"/"+outfile) or namelist.global_vars.force_processing:
#
# Check to see in climo files exist
#
    if not isfile( climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_m+"_"+variable+".nc")   \
        or not isfile(climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_s+"_"+variable+".nc") \
        or not isfile(climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_a+"_"+variable+".nc") \
        or namelist.global_vars.force_processing:
      print "---------",m.dir+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+ CCMVal_field+"_"+variable+".nc"
      if (not isfile(climo_dir+"/"+m.case+"/"+m.case+"_"+m.name+"_"+ \
                variable+"_"+CCMVal_field+".nc") and not isfile(m.dir+"/"+project_name+"_"+m.case+"_"+m.name+"_"+ m.ensemble+"_"+CCMVal_field+"_"+variable+".nc"))   \
         or namelist.global_vars.force_processing:
        environ["MODEL_DIR"]=m.dir
        environ["START_DATE"]=m.start_date
        environ["END_DATE"]=m.end_date
        environ["OUTPUT_FILE"]=climo_dir+"/"+m.case+"/"+m.case+"_"+m.name+"_"+ \
                               variable+"_"+CCMVal_field+"_"+m.start_date+"-"+m.end_date+".nc"
        if not isdir(climo_dir+"/"+m.case+"/"):
          system("mkdir -p "+climo_dir+"/"+m.case+"/")
        environ["VARIABLE"]=variable
        environ["OLD_VARIABLE"]=old_variable
        environ["FIELD_NUMBER"]=CCMVal_field
        print "--------------------------------------------------------------------------------------"
        print "|"
        print "| Process original CCSM model data for variable "+variable+" for "+m.name+" "+m.case+"."
        print "|"
        print "--------------------------------------------------------------------------------------"
        if debug:
           print "Calling ccsm.ncl"
           system("ncl   ./ncl_code/ccsm.ncl")
#caf           xx=popen("ncl   ./ncl_code/ccsm.ncl")
#caf           for line_number, line in enumerate(xx):
#caf             line=line.replace("\n", "")
#caf             if (line_number >=5):
#caf               print line
#caf               if (line.find("ERROR") != -1):  
#caf                 ierror=1
           print "Returning from ccsm.ncl"
        else:
           system("ncl   ./ncl_code/ccsm.ncl >&  NCL_messages")
  return(ierror)

