#!/usr/bin/python

# Converts netcdf file CF 1.1 complaint netcdf file

# 2008/08/22 C. Fischer

# Changes
# 2008/08/27 CAF  Added check to see if files exist, if they do then don't process
# 2008/11/06 CAF  Changed shell call from csh script to ncl script, added ensemble id
# 2008-11-18 CAF  Added climo directory
# 2008-11-18 CAF  replace system call with popen
# 2009-01-27 CAF  added end_date and start_date to enviroment variables in order to create output filename.
#                 also changed climo dir structure
# 2009-05-28 CAF  fixed problem with current working directory
# 2009-06-11 CAF  added date range check to input file
# 2010-12-14 HS/SWW changed input directory and input files & output
# 2011-02-01 ZL   re-introduced one of input filename for ccsm
# 2012-05-11 HS   added a call to test_timerange.ncl - check time range for T*M*

# Known issues:

# What it does:
#  -  Sets enviroment variables then calls a csh script to convert the file
#

from os import environ, system, chdir, popen
from os.path import isfile


def cf_convert(m,variable,CCMVal_field,global_vars,debug=0):
# Change to directory with CF converter code
# Build input and output file names
  indir=global_vars.climo_dir+"/"+m.case
  infile=global_vars.project+'_'+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+".nc"
  if (not isfile(indir+"/"+infile)):
    infile=m.case+"_"+m.name+"_"+variable+"_"+CCMVal_field+"_"+m.start_date+"-"+m.end_date+".nc"
  if (not isfile(indir+"/"+infile)):
    indir=m.dir
    infile=global_vars.project+'_'+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc"
    if (not isfile(indir+"/"+infile)):
      infile=global_vars.project+'_'+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+".nc"
      if (not isfile(indir+"/"+infile)):
        infile=global_vars.project+'_'+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+"*.nc"

  outfile=global_vars.project+'_'+m.case+'_'+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc"

# Set enviroment variables, more need to be set here for better descriptions in the netcdf file headers.
  environ["CCMVal_field"]=CCMVal_field
  environ["inputdir"]=indir   #global_vars.climo_dir+"/"+m.case+"/"
  #caf  environ["outputdir"]=global_vars.climo_dir+"/"+m.start_date+"-"+m.end_date+"/"
  environ["outputdir"]=global_vars.climo_dir+"/"+m.case+"/"
  print "infile=====",indir+"/"+infile
  environ["inputfile"]=infile
  environ["outputfile"]=outfile
  environ["var"]=variable
  environ["var_name"]=variable
  environ["MODEL"]=m.name
  environ["REF"]=m.case
  environ["START_DATE"]=m.start_date
  environ["END_DATE"]=m.end_date

  environ["lat_name"]="lat"
  environ["lon_name"]="lon"
  environ["lev_name"]="plev"
  environ["time_name"]="time"

  environ["source"]=      'CCMVal. Method of production of the original data'
  environ["contact"]=     'National Center for Atmospheric Research WACCM Andrew'
  environ["exp_id"]=      m.ensemble                     # ID ensemble number
  environ["history"]=     'List of the applications that have modified the original data'
  environ["comment"]=     'Miscellaneos information about the data or methods used to produce it'

  environ["references"]=   'These files are created according to CF1.1 see  http://cf-pcmdi.llnl.gov/'
#niwa  environ["fil_out"]=   m.dir+"/"+infile  #global_vars.climo_dir+"/"+m.case+"/"+infile


# Execute the csh script
  print "-------------------------------------------------------------"
  print "outfile====",global_vars.climo_dir+"/"+m.case+"/"+outfile
  print "-------------------------------------------------------------"
  if (not isfile(global_vars.climo_dir+"/"+m.case+"/"+outfile))  or global_vars.force_processing:
    chdir('./reformat')
    print "Doing cf convert."
    if debug:
      xx=popen('ncl ./attribute.ncl')
      for line_number, line in enumerate(xx):
        line=line.replace("\n", "")
        if (line_number >=5):
          print line
    else:
      system('ncl ./attribute.ncl >&  NCL_messages')
    system('ncl ./test_timerange.ncl')
    chdir('..')
  if (not isfile(global_vars.climo_dir+"/"+m.case+"/"+outfile)):
    return(1)
  else:
    return(0)
