;
;
;  Main NCL script
;
;          Called by main.py.  Gets environment variables MODELS, PLOT_TYPES,
;          and VARIABLE.  Load var_att script based on VARIABLE.  Loads or
;          calculates variable to be plotted.  Loops over plot_type calling
;          plot_type scripts
;
;  2008-06-27   CAF
;  2008-08-27   CAF added loads for ncl libraries
;  2009-05-22   CAF changed how information is passed to read_data and calculate
;  2009-05-22   CAF added checks for date ranges in filenames
;  2010-12-15   HS  fixed and modified the conditions to calling function calculate
;
; Dependencies:
;     $NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl
;     ./ncl_code/get_MODELS_envvar.ncl
;     ./ncl_code/calculate.ncl
;     ./ncl_code/read_data.ncl
;     ./plot_type/xyplot.ncl
;     ./plot_type/yzplot.ncl
;     ./plot_type/xzplot.ncl
;     ./var_att/?_att.ncl

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

;cafload "./ncl_code/cshstringtolist.ncl"
load "./ncl_code/get_MODELS_envvar.ncl"
load "./ncl_code/calculate.ncl"
load "./ncl_code/read_data.ncl"
load "./ncl_code/read_from_file.ncl"
load "./ncl_code/get_varName_from_file.ncl"
load "./ncl_code/modify_data.ncl"
load "./ncl_code/extract_data.ncl"
load "./ncl_code/add_data.ncl"

print("In main.ncl")


; Load variable attributes, load calculate function if variable
; is derived
;
variable=getenv("VARIABLE")
if (isfilepresent("./var_att/"+variable+"_att.ncl")) then
  loadscript("./var_att/"+variable+"_att.ncl")
else
  print("./var_att/"+variable+"_att.ncl  NOT FOUND")
  info = False
end if


begin
;
; Get information about the models
;
  project_name=getenv("PROJECT_NAME")
  models=get_MODELS_envvar()
;
; Get directories, plot types and variables for enviroment variables
;
  plot_types=cshstringtolist(getenv("PLOT_TYPES"))
  field_number=getenv("FIELD_NUMBER")
  plot_dir=getenv("WKDIR")
  climo_dir=getenv("CLIMO_DIR")
;
; If info@derived is True, then the calculate function must have been
; defined in ./var_att/?_att.ncl 
;
  data=True
  if (info .eq. True) then
    do i=0,dimsizes(models@name)-1
      temp_models=True
      temp_models@name=models@name(i)
      temp_models@case_name=models@case_name(i)
      temp_models@ensemble=models@ensemble(i)
      temp_models@start_date=models@start_date(i)
      temp_models@end_date=models@end_date(i)
      temp_models@dir=models@dir(i)
      ;print("file="+climo_dir+"/"+models@case_name(i)+"/"+project_name+"_"+ models@case_name(i)+"_"+models@name(i)+"_"+models@ensemble(i)+"_"+field_number+"_"+variable+".nc")
      calcData = False
      if (info@derived) then
        varfile = climo_dir+"/"+models@case_name(i)+"/"+project_name+"_"+models@case_name(i)+"_"+models@name(i)+\
                  "_"+models@ensemble(i)+"_"+field_number+"_"+variable+"_"+models@start_date(i)+"-"+models@end_date(i)+".nc"
        if (.not.isfilepresent(varfile)) then
          calcData = True
        else
          fv = addfile(varfile,"r")
          att_units = fv->$variable$@units
          if (.not.ismissing(att_units)) then
            if (.not.(att_units.eq.info@units)) then
              calcData = True
            end if
          end if
          delete(fv)
          delete(att_units)
        end if
      end if
      if calcData then
        print("calculating data")
        data=calculate(temp_models,variable,field_number)
      else
;       Read variable from netcdf file
        print("reading data")
        data=read_data(temp_models,variable,field_number)
      end if
      delete(temp_models)
    end do
  end if
  do i=0,dimsizes(plot_types)-1,1
    if (.not.isfilepresent(plot_dir+plot_types(i))) then
      system("mkdir -p "+plot_dir+plot_types(i))
    end if
    if (isfilepresent("./plot_type/"+plot_types(i)+".ncl")) then
      loadscript("./plot_type/"+plot_types(i)+".ncl")
    else
      print("ERROR: "+plot_types(i)+".ncl is missing.")
    end if
  end do
end
