#! /usr/bin/python

# main python script
#
# 2008-06-27  CAF
# 2008-08-27  CAF  Added checks for existing files, fixed bug when variable name is changed U->ua
# 2008-11-06  CAF  added ensemble id, output dir for plots, and project name
# 2008-11-18  CAF  added climo and plot directories.
# 2008-11-20  CAF  added support for multiple required variables for derived fields.
# 2008-12-01  CAF  added namelist option on command line, switched system call to ncl to popen
#                  skip variable if it's missing              
# 2009-01-27  CAF  changed climo dir structure
# 2009-03-04  CAF  added logic to handle different file numbers for required variables
# 2009-05-22  CAF  changed method of field_number creation, var_att files can now have *2*z 
#                  *2*s *3* formatted Requires line
# 2009-05-27  CAF  seach for filenames w/wo date range
# 2009-06-12  CAF  Don't do climatology for I and D
# 2010-12-02  HS   added environment variables to set maximum data sizes
# 2010-12-14  HS   added termination call when error occurs with cf_convert
# 2012-06-08  HS   set environment variable (OPTIONS_FILE) if namelist.global_vars.write_plot_vars is defined

from namelist import *
from diagatt import *
from os import environ, system
from ccsm import ccsm
from climat import climat
from cf_convert import cf_convert
from os.path import isfile,basename,isdir
import glob
from var_required import *
from sys import exit,argv


debug=true

#
# Read in namelist
# Filename is currently hard coded, needs to be changed
#
if (len(argv) <= 1):
  print "Error: expected a namelist file"
  exit ()
if isfile(argv[1]):
  namelist=read_namelist(argv[1],debug=false)
else:
  print "Error: can't find "+argv[1]
  exit ()


# set maximum file size to be held in memory (Mbyte)
environ["MAX_DATA_FILESIZE"]="100"

# set maximum data block size to be read (Mbyte)
environ["MAX_DATA_BLOCKSIZE"]="500"

#convert WACCM3 to CCMVal format
#convert to CF format

#
# convert namelist class into a string
#
b=" "
#global_var=namelist.global_vars.force_processing
climo_dir=namelist.global_vars.climo_dir
plot_dir=namelist.global_vars.plot_dir
project_name=namelist.global_vars.project

environ["PROJECT_NAME"]=project_name
environ["WKDIR"]=plot_dir
environ["CLIMO_DIR"]=climo_dir

if hasattr(namelist.global_vars,'write_plot_vars'):
  if namelist.global_vars.write_plot_vars:
    environ["WRITE_PLOT_VARS"]="True"
  else:
    environ["WRITE_PLOT_VARS"]="False"
else:
  environ["WRITE_PLOT_VARS"]="False"

for m in namelist.models:
   a=vars(m)
   #MN: reduce to a few particular attributes that the NCL code looks for
   a = [k+': '+a[k] for k in ('case','dir','name','ensemble','end_date','start_date')]
   b=b+str(a)+","
#
# change characters in namelist string to something
# more NCL friendly.
#
for x in "{}[]' ": b = b.replace(x,"")
b=b.replace(":",":,")

#
# add total number of models to string
#
b= ","+str(len(namelist.models))+","+b
#
# Set enviroment variable to be read in by NCL
#
environ["MODELS"]= b

#print '=>', b
#
# Loop over diag_att file and execute NCL code
#

#
# loop over all diagnostics packages, then through all lines in diag_att file
# convert file format to CF complaint CCMVal2 form, and create climatology
#
  

for d in namelist.diagnostics:
  result=read_diag_att(d.type , debug=false)
  for pltp in result:
    environ["ORIG_VARIABLE"]=pltp.variable
    environ["ORIG_FIELD_NUMBER"]=pltp.field_number
    all_variables=var_required(pltp.variable)
    if all_variables.var[0] == "none":
      all_variables.var[0]=pltp.variable
      all_variables.field[0]=pltp.field_number

    for i in range(len(all_variables.var)):
      variable=all_variables.var[i]
      environ["CURRENT_VARIABLE"]=variable
      new_field_number=all_variables.field[i]
      new_field_number=pltp.field_number[0]+new_field_number[1]+pltp.field_number[2]+new_field_number[3:]
      for m in namelist.models[:]:
        if not isdir(climo_dir+"/"+m.case+"/"):
          system("mkdir -p "+climo_dir+"/"+m.case+"/")
        if m.name == 'CAM' or m.name == 'WACCM':
           if debug: print "Calling ccsm.py"
           ierror=ccsm(m,namelist,variable,new_field_number,debug=debug)
           if debug: print "Returned from ccsm.py"
           if (ierror == 1): break
        CCMVal_field=new_field_number.replace("C","T")
        CCMVal_field_m=CCMVal_field.replace("T","C")
        CCMVal_field_s=CCMVal_field.replace("T","C")
        CCMVal_field_a=CCMVal_field.replace("T","C")
        CCMVal_field_s=CCMVal_field_s.replace("M","S")
        CCMVal_field_a=CCMVal_field_a.replace("M","A")
# convert netcdf file to CF compliant netcdf file, return CF complian variable name
        if debug: print "Calling cf_convert.py"
        errno=cf_convert(m,variable,CCMVal_field,namelist.global_vars,debug=debug)
        if debug: print "Returned from cf_convert.py",errno
        if (errno == 1): exit ()
# calculate climatology
# skip climatology if field is ??I? or ??D?
#
        if "I" not in CCMVal_field and "D" not in CCMVal_field:
          in_file=climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc"

          if ((not isfile(climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_m+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc")   \
              or not isfile(climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_s+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc") \
              or not isfile(climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_a+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc"))) \
              or namelist.global_vars.force_processing: 
            environ["MNAME"]=m.name
            if debug: print "Calling climat.py"
            climat(in_file, \
              climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_m+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc", \
              climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_s+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc", \
              climo_dir+"/"+m.case+"/"+project_name+"_"+m.case+"_"+m.name+"_"+m.ensemble+"_"+CCMVal_field_a+"_"+variable+"_"+m.start_date+"-"+m.end_date+".nc",overwrite='y',debug=debug)
            if debug: print "Returned from climat.py"
#

#
# loop over all diagnostics packages, then through all lines in diag_att file
# call NCL code passing environment variables MODELS, PLOT_TYPES, VARIABLE
#
#caf for d in namelist.diagnostics:
#caf  result=read_diag_att(d.type , debug=debug)
#caf  for pltp in result:
    environ["PLOT_TYPES"]=","+pltp.plot_type+","
    environ["VARIABLE"]=pltp.variable
    environ["FIELD_NUMBER"]=pltp.field_number
    if (pltp.plot_type != "noplot"):
      if debug:
        system("ncl ./main.ncl")
      else:
        system("ncl ./main.ncl  >&  NCL_messages")
  # create tables if file(table_*.nc) exists
filename = plot_dir+"/table_one/table_*.nc"
flist = glob.glob(filename)
for fn in flist:
  shortname = basename(fn)
  system("ncl ./plot_type/make_"+shortname[:-3]+".ncl")
del flist

