#! /usr/bin/python

# Namelist Reader

# 2008/05/30 - C. Fischer
# 2008/06/02 - M. Neish: moved namelist module to a separate file
# 2008/06/06 - M. Neish: converted MODELS/DIAGNOSTICS to a list format.
#                        modified the logic of the parsing routine
# 2008/11/06 - C. Fischer added project, ensemble, and plot_dir
# 2008-11-18 - C. Fischer added more global vars

# Dependencies:

# Known issues:
# -Still need to add GLOBAL variables

# What it does:
#   Reads in a namelist files
#   Create a class for global variables
#     global_var.variable_name           - variable_name is the name of a global variable 
#        true, yes  =  1                   ie (write_netcdf, write_plots)
#        false, no  =  0
#   Creates a class for model information
#     models.name                    - model name
#     models.case                    - case name
#     models.ensemble                - ensemble number
#     models.start_date              - start date of model   yyyy
#     models.end_date                - end date of model run yyyy
#     models.dir                     - location of model data
#     models.number_of_models        - number of models requested
#   Creates a list of diagnostic types
#     diagnostics.types              - array of diagnostic types
#     diagnostics.number_of_types    - number diagnostic types requested

#
# Usage
#   namelist.py namelist_file -debug
#      -debug sets debugging flag to true

import os

#
# Define the classes
#

false = 0
true  = 1

class GLOBAL:
  write_plots  = false
  write_netcdf = false
  debug        = false
class MODEL:
  def __init__(self,new_name,new_case,new_ensemble,new_start_date,new_end_date,new_dir):
    self.name=new_name
    self.case=new_case
    self.ensemble=new_ensemble
    self.start_date=new_start_date
    self.end_date=new_end_date
    self.dir=new_dir
  def __str__(self):
    return self.name+', '+self.case+', '+self.ensemble+', '+self.start_date+'-'+self.end_date
class DIAGNOSTIC:
  def __init__(self,new_type):
    self.type=new_type

# Define an empty namelist structure
class NAMELIST:
  global_vars = GLOBAL()
  models = []
  diagnostics = []


def read_namelist (namelist_file, debug=false):

  namelist = NAMELIST()
  global_vars = namelist.global_vars
  models = namelist.models
  diagnostics = namelist.diagnostics

  #
  # Process optional arguments
  #
  global_vars.debug = debug


  # Namelist sections
  namelist_sections=" GLOBAL MODELS DIAGNOSTICS"

  #
  # Open namelist file and process each line
  #

  f=open(namelist_file,'r')
  section=""
  for line_number, line in enumerate(f):
   line=line.replace("\n", "")
   line=line.split('#')[0]  # Ignore everything after the first '#' character
   tokens=line.split()  # Tokenize the line
   if (len(tokens) == 0): continue  # Skip blank lines
   if len(tokens) == 1 and namelist_sections.find(tokens[0]) > 0:
     section=tokens[0]
     print section, "being defined"
     continue
   if section == '':
     print 'Warning on line',line_number,': no section defined yet, ignoring'
#GLOBAL section
   if section == "GLOBAL":
     if len(tokens) != 2:
       print "Error on line", line_number,": invalid syntax for GLOBAL section"
       exit()
     if tokens[1].lower() in ["true", "yes", "1"]:
       tokens[1] = true
     elif tokens[1].lower() in ["false", "no", "0"]:
       tokens[1] = false
     if tokens[0] == 'write_plots':
       global_vars.write_plots = tokens[1]
     elif tokens[0] == 'write_netcdf':
       global_vars.write_netcdf = tokens[1]
     elif tokens[0] == 'force_processing':
       global_vars.force_processing = tokens[1]
     elif tokens[0] == 'project':
       global_vars.project = tokens[1]
     elif tokens[0] == 'plot_dir':
       global_vars.plot_dir=tokens[1].replace("$wrk_dir",global_vars.wrk_dir)
     elif tokens[0] == 'wrk_dir':
       wdir = tokens[1]
       if wdir[:2] == './':
         global_vars.wrk_dir = wdir.replace(".",os.getcwd(),1)
       else:
         global_vars.wrk_dir = wdir
     elif tokens[0] == 'climo_dir':
       global_vars.climo_dir=tokens[1].replace("$wrk_dir",global_vars.wrk_dir)
     elif tokens[0] == 'write_climo':
       global_vars.write_climo = tokens[1]
     elif tokens[0] == 'write_plot_vars':
       global_vars.write_plot_vars = tokens[1]
     else:
       print 'Error: at line',line_number,line
       print 'Exiting'
       exit()
#MODELS section
   if section == "MODELS":
     if len(tokens) == 6:
       models.append(MODEL(*tokens))
     else:
       print 'Error: at line',line_number,line
       print 'Expecting 5 arguments, found ',len(temp)
       print 'Exiting'
       exit()
# DIAGNOSTICS section
   if section == "DIAGNOSTICS":
     diagnostics.append(DIAGNOSTIC(tokens[0]))
     
  return(namelist)


# Check if we're running from the command line (useful for testing purposes)
if __name__ == '__main__':
  from sys import argv,exit
  from os.path import isfile
  if len(argv) <= 1:
    print "Error: expected a namelist file"
    exit (1)
  if isfile(argv[1]):
    read_namelist(argv[1], debug=1)
  else:
    print "Error: can't find "+argv[1]
    exit (1)

