;
; Function to create the data structure.  This is needed when deriving a field producing a result of a
; different rank, ie tropopause location
;
;  all_data output data
;  new_data input data
;  models  list of models
;  index   current model to have data added
;
; 2009-01-12 CAF created, based off of read_data.ncl
; 2010-11-30 HS  added two attributes (filepath,inMemo) to hold information
;                depends on the attribute (inMemo), data gets write to from memory and/or file.
; 2012-05-16 HS  add some global attributes
;
;
load "./reformat/global_attribute.ncl"

undef("add_data")
procedure add_data(models,all_data,new_data,index)
begin
   ; Get environment variables
   maxDataSize = stringtofloat(getenv("MAX_DATA_FILESIZE"))
   project_name = getenv("PROJECT_NAME")
   field_number = getenv("FIELD_NUMBER")
   climo_dir = getenv("CLIMO_DIR")
   variable = getenv("VARIABLE")
   print ("add_data: variable="+variable+", field_number="+field_number)

   ; Set output filename
   out_file=climo_dir+"/"+models@case_name(index)+"/"+project_name+"_"+models@case_name(index)+"_"+models@name(index)+"_"+models@ensemble(index)+"_"+field_number+"_"+variable+"_"+models@start_date(index)+"-"+models@end_date(index)+".nc"

   all_data = True
   ds = dimsizes(new_data)
   rank = dimsizes(ds)
   ; Check data size
   varType = typeof(new_data)
   if (varType.eq."double") then
      datasize=8.
   else
      datasize=4.
   end if
   do j=0,rank-1,1
      datasize = datasize * ds(j)
   end do
   delete(ds)

   datasize = datasize/1000000  ; in Mbyte
   ;print("datasize="+datasize)

   cn=models@name(index)+"_"+models@case_name(index)+"_"+models@ensemble(index)+"_"+models@start_date(index)+"-"+models@end_date(index)
   cnt=cn+"_filepath"
   all_data@$cnt$ = out_file
   dimNames = getvardims(new_data)
   cnt=cn+"_dimNames"
   all_data@$cnt$ = dimNames

   if (datasize .gt. maxDataSize) then
      ; only on hdd, not in current memory
      cnt=cn+"_inMemo"
      all_data@$cnt$ = 0
      all_data@$cn$ = 0
   else
      ; read into memory
      cnt=cn+"_inMemo"
      all_data@$cnt$ = 1
      all_data@$cn$=(/new_data/)
   end if

   ; Output data to file
   fout = addfile(out_file,"c")
   filedimdef(fout,"time",-1,True)
   fout->$variable$ = new_data

   if (dimNames(0) .ne. "ncl_scalar") then
      do j=0,rank-1,1
         cnt=cn+"_"+dimNames(j)+"_values"
         all_data@$cnt$=new_data&$dimNames(j)$

         ; copy attribute for coord variables
         cnt=cn+"_"+dimNames(j)+"_attNames"
         attNames=getvaratts(new_data&$dimNames(j)$)
         all_data@$cnt$=attNames
         do k=0,dimsizes(attNames)-1,1
            cnt=cn+"_"+dimNames(j)+"_attributes_"+attNames(k)
            all_data@$cnt$=new_data&$dimNames(j)$@$attNames(k)$
         end do
         delete(attNames)
      end do
   end if
   attNames = getvaratts(new_data)
   cnt=cn+"_attNames"
   all_data@$cnt$=attNames
   do j=0,dimsizes(attNames)-1,1
      cnt=cn+"_attributes_"+attNames(j)
      all_data@$cnt$=new_data@$attNames(j)$
   end do

   delete(dimNames)
   delete(attNames)

   ; add global attributes
   fAtt = True                         ; assign file attributes
   fAtt@fields = field_number
   comment = "created by add_data.ncl"
   global_attribute(models@name(index),"","",models@case_name(index),models@ensemble(index),"",comment,"",fAtt)
   file_atts = getvaratts(fAtt)
   do i=0,dimsizes(file_atts)-1
      if (fAtt@$file_atts(i)$ .eq. "") then
         delete(fAtt@$file_atts(i)$)
      end if
   end do
   fileattdef( fout, fAtt )            ; copy file attributes

   delete(fout)
   delete(fAtt) 
   delete(file_atts)
end
