;
;
;  This function takes in a data structure(data) with data for multiple models
;  that was created in read_data.ncl and extracts the data for one model.
;
;  2008-07-25 CAF
;  2008-11-06 CAF
;     added ensemble id
;  2009-01-12 CAF
;     fixed problem with same model but different time period
;  2009-01-28 CAF
;     added copy for coord. attributes
;  2010-11-17 HS
;     added parameters (dim_id,lw_limit,up_limit)
;     dim_id: all_data(-1), dim_index (e.g., 0), or dim_name (e.g., "time")
;     lw_limit/up_limit: lower/upper limits, either index or values
;     depends on the attribute (inMemo), data gets read from memory or file.
;
undef("extract_data")
function extract_data(models,data,index,dim_id,lw_limit,up_limit)
local cn, cnt, dimNames, rank, inMemo, dim_id_num, lw_idx, up_idx, \
      dim_val, attNames, dim_val_idx, dim_val_time, modelfile, \
      variable, temp_data, i, j
begin

   cn=models@name(index)+"_"+models@case_name(index)+"_"+models@ensemble(index)+"_"+models@start_date(index)+"-"+models@end_date(index)

   ; Get dimension names
   cnt=cn+"_dimNames"
   dimNames=data@$cnt$
   rank=dimsizes(dimNames)

   cnt=cn+"_inMemo"
   inMemo = data@$cnt$

   if (dimNames(0) .ne. "ncl_scalar") then

      ; Find out dimension/coordinate number.
      if isnumeric(dim_id) then
         dim_id_num=dim_id
      else
         dim_id_num=ind(dimNames.eq.dim_id)
         if (all(ismissing(dim_id_num))) then
            print("[extract_data.ncl] Dimension Not Found: "+dim_id)
            exit;
         end if
      end if

      ; Find out upper/lower limit index of dimension/coordinate to be selected.
      if (dim_id_num .ne. -1) then
         if (isinteger(lw_limit) .and. isinteger(up_limit)) then
            ; lw_limit & up_limit are index
            lw_idx=lw_limit
            up_idx=up_limit
         else
            ; lw_limit & up_limit are value limits
            cnt=cn+"_"+dimNames(dim_id_num)+"_values"
            dim_val=data@$cnt$

            if (dimNames(dim_id_num).eq."time") then
               cnt=cn+"_"+dimNames(dim_id_num)+"_attNames"
               attNames=data@$cnt$
               do i=0,dimsizes(attNames)-1,1
                  cnt=cn+"_"+dimNames(dim_id_num)+"_attributes_"+attNames(i)
                  dim_val@$attNames(i)$=data@$cnt$
               end do
               delete(attNames)

               dim_val_time=ut_calendar(dim_val,4)
               dim_val_idx=ind((dim_val_time.ge.lw_limit).and.(dim_val_time.le.up_limit))
               delete(dim_val_time)
            else
               dim_val_idx=ind((dim_val.ge.lw_limit).and.(dim_val.le.up_limit))
            end if
            if (all(ismissing(dim_val_idx))) then
               print("[extract_data.ncl] Outside of Range ("+dimNames(dim_id_num)+"): "+flt2string(lw_limit)+","+flt2string(up_limit))
               exit;
            end if
            lw_idx=dim_val_idx(0)
            up_idx=dim_val_idx(dimsizes(dim_val_idx)-1)
            delete(dim_val)
            delete(dim_val_idx)
         end if
      end if

      if (inMemo .eq. 0) then
         ; Read from hdd
         cnt=cn+"_filepath"
         modelfile = data@$cnt$

         ; Get variable name from filename
         variable = get_varName_from_file(modelfile)

         fm = addfile(modelfile,"r")
         if (dim_id_num .eq. -1) then
            data_new=fm->$variable$
         else
            if (rank.eq.4) then
               if (dim_id_num.eq.0) then
                  data_new=fm->$variable$(lw_idx:up_idx,:,:,:)
               end if
               if (dim_id_num.eq.1) then
                  data_new=fm->$variable$(:,lw_idx:up_idx,:,:)
               end if
               if (dim_id_num.eq.2) then
                  data_new=fm->$variable$(:,:,lw_idx:up_idx,:)
               end if
               if (dim_id_num.eq.3) then
                  data_new=fm->$variable$(:,:,:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.3) then
               if (dim_id_num.eq.0) then
                  data_new=fm->$variable$(lw_idx:up_idx,:,:)
               end if
               if (dim_id_num.eq.1) then
                  data_new=fm->$variable$(:,lw_idx:up_idx,:)
               end if
               if (dim_id_num.eq.2) then
                  data_new=fm->$variable$(:,:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.2) then
               if (dim_id_num.eq.0) then
                  data_new=fm->$variable$(lw_idx:up_idx,:)
               else
                  data_new=fm->$variable$(:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.1) then
               data_new=fm->$variable$(lw_idx:up_idx)
            end if
         end if
         delete(fm)
      else
         ; Read from memory
         temp_data=data@$cn$

         ; Loop over all dimensions and create dimensions in data_new
         ; and copy dimension values to data_new
         do i=0,dimsizes(dimNames)-1,1
            cnt=cn+"_"+dimNames(i)+"_values"
            temp_data!i=dimNames(i)
            temp_data&$dimNames(i)$=data@$cnt$

            ; copy out coord attributes
            cnt=cn+"_"+dimNames(i)+"_attNames"
            attNames=data@$cnt$
            do j=0,dimsizes(attNames)-1,1
               cnt=cn+"_"+dimNames(i)+"_attributes_"+attNames(j)
               temp_data&$dimNames(i)$@$attNames(j)$=data@$cnt$
            end do
            delete(attNames)
         end do

         ; Get attribute names
         cnt=cn+"_attNames"
         attNames=data@$cnt$
         ; Create attributes of data_new
         do i=0,dimsizes(attNames)-1,1
            cnt=cn+"_attributes_"+attNames(i)
            temp_data@$attNames(i)$=data@$cnt$
         end do

         if (dim_id_num .eq. -1) then
            data_new=temp_data
         else
            if (rank.eq.4) then
               if (dim_id_num.eq.0) then
                  data_new=temp_data(lw_idx:up_idx,:,:,:)
               end if
               if (dim_id_num.eq.1) then
                  data_new=temp_data(:,lw_idx:up_idx,:,:)
               end if
               if (dim_id_num.eq.2) then
                  data_new=temp_data(:,:,lw_idx:up_idx,:)
               end if
               if (dim_id_num.eq.3) then
                  data_new=temp_data(:,:,:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.3) then
               if (dim_id_num.eq.0) then
                  data_new=temp_data(lw_idx:up_idx,:,:)
               end if
               if (dim_id_num.eq.1) then
                  data_new=temp_data(:,lw_idx:up_idx,:)
               end if
               if (dim_id_num.eq.2) then
                  data_new=temp_data(:,:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.2) then
               if (dim_id_num.eq.0) then
                  data_new=temp_data(lw_idx:up_idx,:)
               else
                  data_new=temp_data(:,lw_idx:up_idx)
               end if
            end if
            if (rank.eq.1) then
               data_new=temp_data(lw_idx:up_idx)
            end if
         end if
         delete(temp_data)
      end if
      ; Reduce its rank/dimension
      if ((dim_id_num .ne. -1).and.(lw_idx.eq.up_idx)) then
         temp_data = dim_avg_n_Wrap(data_new,dim_id_num)
         delete(data_new)
         data_new = temp_data
         delete(temp_data)
      end if
   else
      ; Copy data values into data_new
      data_new=data@$cn$

      ; Get attribute names
      cnt=cn+"_attNames"
      attNames=data@$cnt$
      ; Create attributes of data_new
      do i=0,dimsizes(attNames)-1,1
         cnt=cn+"_attributes_"+attNames(i)
         data_new@$attNames(i)$=data@$cnt$
      end do
   end if

   return(data_new)
end
