;
;
;  This procedure modifies data in the data structure.
;  Only modifies data and not dimensions or attributes
;
;  2008-07-25 CAF
;  2008-11-06 CAF    
;     added ensemble id
;  2009-01-12 CAF
;     fixed problem with same model but different time period
;  2010-11-29 HS
;     depends on the attribute (inMemo), data gets write to from memory and/or file.
;     also variable attribute (@units) gets updated to match data content.
;  2012-05-16 HS
;     pass global attributes from initial file (fin)
;
;
undef("modify_data")
procedure modify_data(models,data,data_new,index)
begin
   cn=models@name(index)+"_"+models@case_name(index)+"_"+models@ensemble(index)+"_"+models@start_date(index)+"-"+models@end_date(index)

   cnt=cn+"_inMemo"
   inMemo = data@$cnt$

   if (inMemo .eq. 1) then
      ; Copy data_new values into data
      data@$cn$=data_new
   end if

   ; Update attribute (@units)
   cnt=cn+"_attributes_units"
   data@$cnt$=data_new@units

   ; Write to hdd
   cnt=cn+"_filepath"
   modelfile = data@$cnt$

   ; Modify filename
   delimiter="/"
   file_parts = str_split(modelfile,delimiter)
   idxLast = dimsizes(file_parts)-1
   file_parts(idxLast) = "junk.nc"
   tempfile = str_join(file_parts,delimiter)
   if (file_parts(0).ne.".") then
      tempfile = "/"+tempfile
   end if
   print("tempfile="+tempfile)

   ; Get variable name
   variable = get_varName_from_file(modelfile)

   ; Output data to file
   fout = addfile(tempfile,"c")
   filedimdef(fout,"time",-1,True)
   fout->$variable$ = data_new

   fin = addfile (modelfile, "r")
   vNames = getfilevarnames(fin)
   if (sum(where(vNames.eq."hyam",1,0)).gt.0) then
      fout->hyam = fin->hyam
   end if
   if (sum(where(vNames.eq."hybm",1,0)).gt.0) then
      fout->hybm = fin->hybm
   end if
   if (sum(where(vNames.eq."hyai",1,0)).gt.0) then
      fout->hyai = fin->hyai
   end if
   if (sum(where(vNames.eq."hybi",1,0)).gt.0) then
      fout->hybi = fin->hybi
   end if
   if (sum(where(vNames.eq."p0",1,0)).gt.0) then
      fout->p0 = fin->p0
   end if

   ; copy global attributes
   file_atts = getvaratts(fin)
   if (.not.all(ismissing(file_atts))) then
      do i = 0,dimsizes(file_atts)-1
         fout@$file_atts(i)$ = fin@$file_atts(i)$
      end do
   end if
   delete(file_atts)

   delete(fin)
   delete(vNames)
   delete(fout)

   system("mv "+tempfile+" "+modelfile)  ;? system("/bin/mv "+tempfile+" "+modelfile)

end
