;
; 2008-06-27 CAF  function to read in date from netcdf files
;                 currently just a place holder
; 2008-07-18 CAF  modified to read in climo files from AMWG diag
; 2008-07-25 CAF  modified to create a structure that allows
;                 different dimensioned data to be read in.
; 2008-08-27 CAF  Improved file search some
; 2008-10-28 CAF  Added field_number
; 2008-11-06 CAF  Added ensemble id
; 2009-01-12 CAF  fixed problem with same model but different time period
; 2009-01-20 CAF  added coord variable attributes copying to structure
; 2009-01-27 CAF  change filename and climo directory structure
; 2009-03-10 CAF  if double there turn float value
; 2009-05-22 CAF  field_number that is passed in can have a format of
;                 *2*s *2*z *3*, then the C or T replace the first *
;                 I or M replaced the second *.  This is based on the
;                 original field number.  Leaving out the * forces
;                 that character to be used.
; 2009-05-22 CAF  check for filenames with and without date range in the filename
; 2009-05-22 CAF  fixed deletion error
; 2009-05-27 CAF  error check for out of date range
; 2009-05-28 CAF  fixed error check for out of date range
; 2009-07-18 CAF  fixes from some models
; 2010-11-17 HS   added two attributes (filepath,inMemo) to hold information
;                 data exceeds maxDataSize, then don't get loaded at this stage
; 2010-11-26 HS   file formats problems are dealt in earlier stages now.
;
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"

undef("read_data")
function read_data(models,variable,field_number)
begin
   maxDataSize = stringtofloat(getenv("MAX_DATA_FILESIZE"))
   project_name=getenv("PROJECT_NAME")
   orig_field_number=getenv("ORIG_FIELD_NUMBER")
   temp=stringtochar(field_number)
   temp1=stringtochar(orig_field_number)
   if temp(0).eq."*" then
     temp(0)=temp1(0)
   end if
   if temp(2).eq."*" then
      temp(2)=temp1(2)
   end if
   field_number=chartostring(temp)
   delete(temp)
   delete(temp1)
   climo_dir=getenv("CLIMO_DIR")
   data_new = True
   do i=0,dimsizes(models@dir)-1,1
      in_file=climo_dir+"/"+models@case_name(i)+"/"+project_name+"_"+models@case_name(i)+"_"+models@name(i)+"_"+models@ensemble(i)+"_"+field_number+"_"+variable+"_"+models@start_date(i)+"-"+models@end_date(i)+".nc"

      print("read_data.ncl:Reading in file="+in_file)

      fid=addfile(in_file,"r")
      cn=models@name(i)+"_"+models@case_name(i)+"_"+models@ensemble(i)+"_"+models@start_date(i)+"-"+models@end_date(i)
      cnt=cn+"_filepath"
      data_new@$cnt$ = in_file

      ; check data size
      ; datasize = systemfunc("ls -s "+in_file+" | cut -d ' ' -f1")
      varType = getfilevartypes(fid,variable)
      if (varType.eq."double") then
         datasize=8.
      else
         datasize=4.
      end if

      dimt = getfilevardimsizes(fid,variable)
      rank = dimsizes(dimt)
      do j=0,rank-1,1
         datasize = datasize * dimt(j)
      end do
      delete(dimt)

      datasize = datasize/1000000  ; in Mbyte
      ;print("datasize="+datasize)

      dimNames = getfilevardims(fid,variable)
      cnt=cn+"_dimNames"
      data_new@$cnt$ = dimNames

      if (datasize .gt. maxDataSize) then
         ; only on hdd, not in current memory
         cnt=cn+"_inMemo"
         data_new@$cnt$ = 0
         data_new@$cn$ = 0
         if (dimNames(0) .ne. "ncl_scalar") then
            do j=0,rank-1,1
               cnt=cn+"_"+dimNames(j)+"_values"
               varCoords = fid->$dimNames(j)$
               data_new@$cnt$=(/varCoords/)
               ; copy attribute for coord variables
               cnt = cn+"_"+dimNames(j)+"_attNames"
               attNames=getvaratts(varCoords)
               data_new@$cnt$=attNames
               do k=0,dimsizes(attNames)-1,1
                  cnt=cn+"_"+dimNames(j)+"_attributes_"+attNames(k)
                  data_new@$cnt$=varCoords@$attNames(k)$
               end do
               delete(varCoords)
               delete(attNames)
            end do
         end if
         if (rank.eq.4)
            var0 = fid->$variable$(0,0,0,0)
         end if
         if (rank.eq.3)
            var0 = fid->$variable$(0,0,0)
         end if
         if (rank.eq.2)
            var0 = fid->$variable$(0,0)
         end if
         if (rank.eq.1)
            var0 = fid->$variable$(0)
         end if
         attNames = getvaratts(var0)
         cnt=cn+"_attNames"
         data_new@$cnt$=attNames(rank:dimsizes(attNames)-1)
         do j=rank,dimsizes(attNames)-1,1
            cnt=cn+"_attributes_"+attNames(j)
            data_new@$cnt$=var0@$attNames(j)$
         end do
         delete(var0)
      else
         ; read into memory
         cnt=cn+"_inMemo"
         data_new@$cnt$ = 1
         data = fid->$variable$
         data_new@$cn$=(/data/)
         if (dimNames(0) .ne. "ncl_scalar") then
            do j=0,rank-1,1
               cnt=cn+"_"+dimNames(j)+"_values"
               data_new@$cnt$=data&$dimNames(j)$
               ; copy attribute for coord variables
               cnt = cn+"_"+dimNames(j)+"_attNames"
               attNames=getvaratts(data&$dimNames(j)$)
               data_new@$cnt$=attNames
               do k=0,dimsizes(attNames)-1,1
                  cnt=cn+"_"+dimNames(j)+"_attributes_"+attNames(k)
                  data_new@$cnt$=data&$dimNames(j)$@$attNames(k)$
               end do
               delete(attNames)
            end do
         end if
         attNames = getvaratts(data)
         cnt=cn+"_attNames"
         data_new@$cnt$=attNames
         do j=0,dimsizes(attNames)-1,1
            cnt=cn+"_attributes_"+attNames(j)
            data_new@$cnt$=data@$attNames(j)$
         end do
         delete(data)
      end if
      delete(attNames)
      delete(dimNames)
      delete(fid)
   end do
   return(data_new)
end
