;
; 2009-02-25 CAF converted read_data.ncl to be able to read in vertical level information
; 2009-05-22 CAF  field_number that is passed in can have a format of
;                 *2*s *2*z *3*, then the C or T replace the first *
;                 I or M replaced the second *.  This is based on the
;                 original field number.  Leaving out the * forces
;                 that character to be used.
; 2009-05-22 CAF  check for filenames with and without date range in the filename
; 2009-05-22 CAF  fixed deletion error
; 
;

undef("read_from_file")
function read_from_file(models,i,variable,sub_var,field_number)
begin
  project_name=getenv("PROJECT_NAME")
  climo_dir=getenv("CLIMO_DIR")
  orig_field_number=getenv("ORIG_FIELD_NUMBER")
  temp=stringtochar(field_number)
  temp1=stringtochar(orig_field_number)
  if temp(0).eq."*" then
    temp(0)=temp1(0)
  end if
  if temp(2).eq."*" then
    temp(2)=temp1(2)
  end if
  field_number=chartostring(temp)
  delete(temp)
  delete(temp1)

  in_file=climo_dir+"/"+models@case_name(i)+"/"+project_name+"_"+models@case_name(i)+  "_"+models@name(i)+"_"+models@ensemble(i)+"_"+field_number+"_"+variable+"_"+models@start_date(i)+"-"+models@end_date(i)+".nc"
  if (.not.isfilepresent(in_file))then
    in_file=climo_dir+"/"+models@case_name(i)+"/"+project_name+"_"+models@case_name(i)+  "_"+models@name(i)+"_"+models@ensemble(i)+"_"+field_number+"_"+variable+".nc"
    if (.not.isfilepresent(in_file))then
      in_file=models@dir(i)+"/"+project_name+"_"+models@case_name(i)+"_"+models@name(i)+"_"+models@ensemble(i)+"_"+field_number+"_"+variable+".nc"
    end if
  end if

  print("read_from_file:"+in_file)
  fid=addfile(in_file,"r")
  data = fid->$sub_var$
  if (isdouble(data)) then 
   return(dble2flt(data))
  end if 
  return(data)
end
