;
;  Save a derived field to a netcdf file
;
;  2008/11/26   C. Fischer   created
;  2009/01/27   CAF      changed output filename and climo directory structure
;  2009/06/24   CAF      added date range to output filename
;
begin
  orig_field_number=getenv("ORIG_FIELD_NUMBER")
  print("Saving to netcdf file"+" "+orig_field_number+" "+variable)
;  a = extract_data(models,data,0,-1,0,0)
  project_name=getenv("PROJECT_NAME")
  climo_dir=getenv("CLIMO_DIR")
  data_new = True
  do i=0,dimsizes(models@dir)-1,1
    filename=climo_dir+"/"+models@case_name(i)+"/"+project_name+ \ 
             "_"+models@case_name(i)+"_"+models@name(i)+"_"+models@ensemble(i)+"_"+orig_field_number+"_"+variable+"_"+models@start_date(i)+"-"+models@end_date(i)+".nc"
    error=systemfunc("rm -f "+filename)
    fout = addfile(filename,"c")
    A = extract_data(models,data,i,-1,0,0)
    fout->$variable$=A
    delete(A)
  end do
end
