;*********************************************************************
; This is the main ncl program called from the script file cf_convert.py
; att_function.ncl
;
; contact  I. Cionni     i.cionni@niwa.co.nz
;
; Changes
; 2010-12-13   HS   bug fix. '_FillValue' needs to get called before deletion of attributes as well
;                   otherwise, previous '_FillValue' value is considered as a valid value.
;                   general tidy-up including code alignments
;*********************************************************************
;_______________________________________________________________________________
;      function  var_list(var_name:string; var:numeric)
;_______________________________________________________________________________
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
undef("var_list")
function var_list ( var_name:string,var:numeric )
local var,var_name
begin
   var = var
   var@_FillValue = 1e+20
   delete_VarAtts(var,-1)
   var@_FillValue = 1e+20

;*************       1      ***********************
   if (var_name.eq."ta") then
;      var@comment="comment????"
;      var@reference="?"
;      var@missing_value = 1.0* 10^(20) ;
;      var@_FillValue = var@missing_value
       var@_FillValue =1.0*10^(20)
       var@standard_name = "air_temperature" ;
       var@units = "K" ;
       var@long_name = "Temperature" ;
   end if

;*************       2     ***********************
   if (var_name.eq."ta10") then
      var@comment="air_temperature on selected level: 10 hPa"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "air_temperature" ;
      var@units = "K" ;
      var@long_name = "Temperature at the 10 hPa surface " ;
   end if

;*************       3    ***********************
   if (var_name.eq."ta100") then
      var@comment="air_temperature on selected level: 100 hPa"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "air_temperature" ;
      var@units = "K" ;
      var@long_name = "Temperature at the 100 hPa surface " ;
   end if

;*****************     4 **********************
   if (var_name.eq."plev") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "air_pressure" ;
      var@units = "Pa" ;
      var@long_name = "Pressure" ;
   end if

;****************** 5        ***************************
   if (var_name.eq."vorpot") then
;      var@comment="comment????"
;      var@reference="?"
;      var@_FillValue = 1e20 ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "ertel_potential_vorticity" ;
      var@units = "K m^(2) Kg^(-1) s^(-1)" ;
      var@long_name = "Ertel Potential Vorticity" ;
   end if

;****************** 6        ***************************
   if (var_name.eq."vorpot840") then
;      var@comment="comment????"
;      var@reference="?"
;      var@_FillValue = 1e20 ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "ertel_potential_vorticity" ;
      var@units = "K m^(2) Kg^(-1) s^(-1)" ;
      var@long_name = "Ertel Potential Vorticity at 840 K" ;
   end if

;****************** 7        ***************************
   if (var_name.eq."vorpot480") then
;      var@comment="comment????"
;      var@reference="?"
;      var@_FillValue = 1e20 ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "ertel_potential_vorticity" ;
      var@units = "K m^(2) Kg^(-1) s^(-1)" ;
      var@long_name = "Ertel Potential Vorticity at 480 K" ;
   end if

;******************    8     ***** **********************
   if (var_name.eq."zg") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "geopotential_height" ;
      var@units = "m" ;
      var@long_name = "Geopotential Height" ;
   end if

;******************    9     ***** **********************
   if (var_name.eq."zg10") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "geopotential_height" ;
      var@units = "m" ;
      var@long_name = "Geopotential Height at 10 mb" ;
   end if

;******************    10     ***** **********************
   if (var_name.eq."zg100") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "geopotential_height" ;
      var@units = "m" ;
      var@long_name = "Geopotential Height at 100 mb" ;
   end if

;******************    11     ***** **********************
   if (var_name.eq."zg500") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "geopotential_height" ;
      var@units = "m" ;
      var@long_name = "Geopotential Height at 500 mb" ;
   end if

;********************************  12    ****************************
   if (var_name.eq."ua") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "eastward_wind" ;
      var@long_name = "Zonal wind" ;
      var@units = "m s-1" ;
   end if

;*********************** 13   *******************************
   if (var_name.eq."va") then
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_wind" ;
      var@long_name = "Meridional wind" ;
      var@units = "m s-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;********************************  14    ****************************
   if (var_name.eq."ua10") then
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "eastward_wind" ;
      var@long_name = "Zonal wind at 10 mb" ;
      var@units = "m s-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;********************************  15    ****************************
   if (var_name.eq."ua100") then
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "eastward_wind" ;
      var@long_name = "Zonal wind at 100 mb" ;
      var@units = "m s-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*********************** 16   *******************************
   if (var_name.eq."va10") then
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_wind" ;
      var@long_name = "Meridional wind at 10 mb" ;
      var@units = "m s-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*********************** 17   *******************************
   if (var_name.eq."va100") then
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_wind" ;
      var@long_name = "Meridional wind at 100 mb" ;
      var@units = "m s-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;******************    18     ***** **********************
   if (var_name.eq."wa") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "upward_air_velocity" ;
      var@units = "m s^(-1)" ;
      var@long_name = "Vertical Velocity" ;
   end if

;******************    19     ***** **********************
   if (var_name.eq."wap") then
;      var@comment="comment????"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name = "lagrangian_tendency_of_air_pressure" ;
      var@units = "Pa s^(-1)" ;
      var@long_name = "Omega" ;
   end if

;******************    20     ***** **********************
   if (var_name.eq."ps") then
;      var@comment="?"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="surface_air_pressure" ;
      var@units = "Pa" ;
      var@long_name = "Surface Pressure" ;
   end if

;******************    21     ***** **********************
   if (var_name.eq."tos") then
;      var@comment="?"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="sea_surface_temperature" ;
      var@units = "K" ;
      var@long_name = "Sea Surface Temperature" ;
   end if

;******************    22     ***** **********************
   if (var_name.eq."sic") then
;      var@comment="?"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="sea_ice_area_fraction" ;
      var@units = "%" ;
      var@long_name = "Area fraction of Sea Ice" ;
   end if

;******************    23     ***** **********************
   if (var_name.eq."tas") then
;     var@comment=""
      var@reference="Near surface air temperature, table A2a no.5 of IPCC standard output"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="air_temperature" ;
      var@units = "K" ;
      var@long_name = "Air Temperature" ;
   end if

;******************    24     ***** **********************
   if (var_name.eq."tasmin") then
;     var@comment=""
      var@reference="Minimum Near surface air temperature, table A2a no.5 of IPCC standard output"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="air_temperature" ;
      var@units = "K" ;
      var@long_name = "Air Temperature Minimum" ;
   end if

;******************    25     ***** **********************
   if (var_name.eq."tasmax") then
;     var@comment=""
      var@reference="Maximum Near surface air temperature, table A2a no.5 of IPCC standard output"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="air_temperature" ;
      var@units = "K" ;
      var@long_name = "Air Temperature Maximum" ;
   end if

;******************    26     ***************************
   if (var_name.eq."ptp") then
;     var@comment=""
     var@reference="1D Zonal mean thermal tropopause calculated using WMO tropopause definition on 3D temperature"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="tropopause_air_pressure" ;
      var@units = "Pa" ;
      var@long_name = "Tropopause Air Pressure" ;
   end if

;******************    27     ***** **********************
   if (var_name.eq."tatp") then
;      var@comment=""
      var@reference="1D Zonal mean thermal tropopause calculated using WMO tropopause definition on 3D temperature"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="tropopause_air_temperature" ;
      var@units = "K" ;
      var@long_name = "Tropopause Air Temperature" ;
   end if

;******************    28     ***** **********************
   if (var_name.eq."ztp") then
;      var@comment=""
      var@reference="1D Zonal mean thermal tropopause calculated using WMO tropopause definition on 3D temperature"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
      var@standard_name ="tropopause_altitude" ;
      var@units = "Pa" ;
      var@long_name = "Tropopause Altitude" ;
   end if

;*******************   29  ****************************************
   if (var_name.eq."toz") then
      var@comment="Total ozone column in DU"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "equivalent_thickness_at_stp_of_atmosphere_ozone_content" ;
      var@units = "DU" ;
      var@long_name = "Total Ozone Column"
   end if

;******************* 30 *****************************************
   if (var_name.eq."rsds") then
      var@comment="surface solar radiation"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "surface_downwelling_shortwave_flux_in_air" ;
      var@units = "W m^(2)" ;
      var@long_name = "Surface downwelling shortwave flux"
   end if

;******************* 31 *****************************************
   if (var_name.eq."rsdscs") then
      var@comment="surface solar radiation clear sky"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "surface_downwelling_shortwave_flux_in_air_assuming_clear_sky" ;
      var@units = "W m^(2)" ;
      var@long_name = "Surface downwelling shortwave Flux clear sky"
   end if

;******************* 32 *****************************************
   if (var_name.eq."tntsw") then
      var@comment="shortwave heating rates"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name ="tendency_of_air_temperature_due_to_shortwave_heating" ;
      var@units = "K s^(-1)" ;
      var@long_name = "Shortwave Heating Rate"
   end if

;******************* 33 *****************************************
   if (var_name.eq."nufl") then
      var@comment="Outgoing longwave radiation"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "net_upward_longwave_flux_in_air" ;
      var@units = "W m^(2)" ;
      var@long_name = "Net Upward Longwave Flux in Air"
   end if

;******************* 34 *****************************************
   if (var_name.eq."tntmc") then
      var@comment="longwave heating rates"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "tendency_of_air_temperature_due_to_longwave_heatin" ;
      var@units = "K s^(-1)" ;
      var@long_name = "Longwave Heating Rate "
   end if

;************************* 35 *******************************************
   if (var_name.eq."clt") then
;      var@comment="?"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "cloud_area_fraction" ;
      var@units = "%" ;
      var@long_name = "Cloud Area Fraction"
   end if

;************************* 36 *******************************************
   if (var_name.eq."convclt") then
      var@comment="2D"
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "convective_cloud_area_fraction" ;
      var@units = "%" ;
      var@long_name = "Convective Cloud Area Fraction"
   end if

;************************* 37 *******************************************
   if (var_name.eq."snd") then
      var@comment=""
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "surface_snow_thickness" ;
      var@units = "m" ;
      var@long_name = "Snow Depth"
   end if

;************************* 38 *******************************************
   if (var_name.eq."snw") then
      var@comment=""
;      var@reference="?"
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@cell_method= "???pressure level :integration????"
      var@standard_name = "surface_snow_amount_where_land" ;
      var@units = "kg m ^(-2)" ;
      var@long_name = "Total Snow "
   end if

;*************************39*********************************************
   if (var_name.eq."O3")
      var@standard_name = "mole_fraction_of_ozone_in_air" ;
      var@long_name = "O3" ;
      var@units = "mole mole^-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@comment=""
;      var@reference="
   end if

;*************************40*********************************************
   if (var_name.eq."N2O")
      var@standard_name = "mole_fraction_of_nitrous_oxide_in_air" ;
      var@long_name = "N2O" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
;      var@comment=""
;      var@reference="
   end if

;*************************41*********************************************
   if (var_name.eq."CH4") then
      var@standard_name = "mole_fraction_of_methane_in_air" ;
      var@long_name = "CH4" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************42*********************************************
   if (var_name.eq."HCl") then
      var@standard_name = "mole_fraction_of_hydrogen_chloride_in_air" ;
      var@long_name = "HCl" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************43*********************************************
   if (var_name.eq."H2O") then
      var@standard_name = "mole_fraction_of_water_in_air" ;
      var@long_name = "H2O" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************44*********************************************
   if (var_name.eq."O3s") then
      var@standard_name = "mole_fraction_of_passive_ozone_in_air" ;
      var@long_name = "O3s" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************45*********************************************
   if (var_name.eq."CFCl3") then
      var@standard_name = "mole_fraction_of_CFC11_in_air" ;
      var@long_name = "CFCl3" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************46*********************************************
   if (var_name.eq."CF2Cl2") then
      var@standard_name = "mole_fraction_of_CFC12_in_air" ;
      var@long_name = "CF2Cl2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************47*********************************************
   if (var_name.eq."CH3Cl") then
      var@standard_name = "mole_fraction_of_methyl_chloride_in_air" ;
      var@long_name = "CH3Cl" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************48*********************************************
   if (var_name.eq."CH3Br") then
      var@standard_name = "mole_fraction_of_methyl_bromide_in_air" ;
      var@long_name = "CH3Cl" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************49*********************************************
   if (var_name.eq."CCl2FCClF2") then
      var@standard_name = "mole_fraction_of_CFC113_in_air" ;
      var@long_name = "CCl2FCClF" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************50*********************************************
   if (var_name.eq."CCl3CF3") then
      var@standard_name = "mole_fraction_of_CFC113a_in_air" ;
      var@long_name = "CCl3CF3" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************51*********************************************
   if (var_name.eq."CClF2CClF2") then
     var@standard_name = "mole_fraction_of_CFC114_in_air" ;
     var@long_name = "CClF2CClF2" ;
     var@units = "mole mole-1" ;
     var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************52*********************************************
   if (var_name.eq."CClF2CF3") then
      var@standard_name = "mole_fraction_of_CFC115_in_air" ;
      var@long_name = "CClF2CF3" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************53*********************************************
   if (var_name.eq."CCl4") then
      var@standard_name = "mole_fraction_of_carbon_tetrachloride_in_air" ;
      var@long_name = "CCl4" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************54*********************************************
   if (var_name.eq."CBrF3") then
      var@standard_name = "mole_fraction_of_halon1301_in_air" ;
      var@long_name = "CBrF3" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************55*********************************************
   if (var_name.eq."CBrClF2") then
      var@standard_name = "mole_fraction_of_halon1211_in_air" ;
      var@long_name = "CBrClF2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************56*********************************************
   if (var_name.eq."C2Br2F4") then
      var@standard_name = "mole_fraction_of_halon2402_in_air" ;
      var@long_name = "C2Br2F4" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************57*********************************************
   if (var_name.eq."CBr2F2") then
      var@standard_name = "mole_fraction_of_halon1201_in_air" ;
      var@long_name = "CBr2F2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************58*********************************************
   if (var_name.eq."Cl") then
      var@standard_name = "mole_fraction_of_atomic_chlorine_in_air" ;
      var@long_name = "Cl" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************59*********************************************
   if (var_name.eq."ClO") then
      var@standard_name = "mole_fraction_of_chlorine_monoxide_in_air" ;
      var@long_name = "ClO" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************60*********************************************
   if (var_name.eq."Cl2O2") then
      var@standard_name = "mole_fraction_of_dichlorine_peroxide_in_air" ;
      var@long_name = "Cl2O2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************61*********************************************
   if (var_name.eq."HOCl") then
      var@standard_name = "mole_fraction_of_hypochlorous_acid_in_air" ;
      var@long_name = "Cl2O2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
     end if

;*************************62*********************************************
   if (var_name.eq."ClONO2") then
      var@standard_name = "mole_fraction_of_chlorine_nitrate_in_air" ;
      var@long_name = "ClONO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************63*********************************************
   if (var_name.eq."OClO") then
      var@standard_name = "mole_fraction_of_chlorine_dioxide_in_air" ;
      var@long_name = "OClO" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************64*********************************************
   if (var_name.eq."Cly") then
      var@standard_name = "mole_fraction_of_inorganic_chlorine_in_air" ;
      var@long_name = "Cly" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************65*********************************************
   if (var_name.eq."OH") then
      var@standard_name = "mole_fraction_of_hydroxyl_radical_in_air" ;
      var@long_name = "OH" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
     end if

;*************************66*********************************************
   if (var_name.eq."HO2") then
      var@standard_name = "mole_fraction_of_hydroperoxyl_radical_in_air" ;
      var@long_name = "HO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************67*********************************************
   if (var_name.eq."H2O2") then
      var@standard_name = "mole_fraction_of_hydrogen_peroxide_in_air" ;
      var@long_name = "H2O2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************68*********************************************
   if (var_name.eq."H2") then
      var@standard_name = "mole_fraction_of_molecular_hydrogen_in_air" ;
      var@long_name = "H2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************69*********************************************
   if (var_name.eq."N") then
      var@standard_name = "mole_fraction_of_atomic_nitrogen_in_air" ;
      var@long_name = "N" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************70*********************************************
   if (var_name.eq."NO") then
      var@standard_name = "mole_fraction_of_nitrogen_monoxide_in_air" ;
      var@long_name = "NO" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************71*********************************************
   if (var_name.eq."NO2") then
      var@standard_name = "mole_fraction_of_nitrogen_dioxide_in_air" ;
      var@long_name = "NO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************72*********************************************
   if (var_name.eq."HNO3") then
      var@standard_name = "mole_fraction_of_nitric_acid_in_air" ;
      var@long_name = "HNO3" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************73*********************************************
   if (var_name.eq."N2O5") then
      var@standard_name = "mole_fraction_of_dinitrogen_pentoxide_in_air" ;
      var@long_name = "N2O5" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************74*********************************************
   if (var_name.eq."HNO4") then
      var@standard_name = "mole_fraction_of_peroxynitric_acid_in_air" ;
      var@long_name = "HNO4" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************75*********************************************
   if (var_name.eq."NOy") then
      var@standard_name = "mole_fraction_of_reactive_nitrogen_in_air" ;
      var@long_name = "NOy" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************76*********************************************
   if (var_name.eq."Br") then
      var@standard_name = "mole_fraction_of_atomic_bromine_in_air" ;
      var@long_name = "Br" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************77*********************************************
   if (var_name.eq."BrO") then
      var@standard_name = "mole_fraction_of_bromine_monoxide_in_air" ;
      var@long_name = "BrO" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************78*********************************************
   if (var_name.eq."BrCl") then
      var@standard_name = "mole_fraction_of_bromine_chloride_in_air" ;
      var@long_name = "BrCl" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************79*********************************************
   if (var_name.eq."HBr") then
      var@standard_name = "mole_fraction_of_hydrogen_bromide_in_air" ;
      var@long_name = "HBr" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************80*********************************************
   if (var_name.eq."HOBr") then
      var@standard_name = "mole_fraction_of_hypobromous_acid_in_air" ;
      var@long_name = "HOBr" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************81*********************************************
   if (var_name.eq."BrONO2") then
      var@standard_name = "mole_fraction_of_bromine_nitrate_in_air" ;
      var@long_name = "BrONO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************82*********************************************
   if (var_name.eq."Bry") then
      var@standard_name = "mole_fraction_of_total_inorganic_bromine_in_air" ;
      var@long_name = "BrONO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************83*********************************************
   if (var_name.eq."CH2O") then
      var@standard_name = "mole_fraction_of_formaldehyde_in_air" ;
      var@long_name = "CH2O" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************84*********************************************
   if (var_name.eq."CH3OOH") then
      var@standard_name = "mole_fraction_of_methyl_hydroperoxide_in_air" ;
      var@long_name = "CH3OOH" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************85*********************************************
   if (var_name.eq."CO") then
      var@standard_name = "mole_fraction_of_carbon_monoxide_in_air" ;
      var@long_name = "CO" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************86*********************************************
   if (var_name.eq."CO2") then
      var@standard_name = "mole_fraction_of_carbon_dioxide_in_air" ;
      var@long_name = "CO2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************87*********************************************
   if (var_name.eq."C2H6") then
      var@standard_name = "mole_fraction_of_ethan_in_air" ;
      var@long_name = "C2H6" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************88*********************************************
   if (var_name.eq."C2H2") then
      var@standard_name = "mole_fraction_of_ethyne_in_air" ;
      var@long_name = "C2H2" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************89*********************************************
   if (var_name.eq."HCN") then
      var@standard_name = "mole_fraction_of_hydrogen_cyanide_in_air" ;
      var@long_name = "HCN" ;
      var@units = "mole mole-1" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************90*********************************************
   if (var_name.eq."mean_age_of_air") then
      var@standard_name = "mean_age_of_air" ;
      var@long_name = "mean_age_of_air" ;
      var@units = "years" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************91*********************************************
   if (var_name.eq."vt100") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_heat_flux_due_to_eddy_advection" ;
      var@long_name = "Vt_100hPa" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************92*********************************************
   if (var_name.eq."fy") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_eliassen_palm_flux" ;
      var@long_name = "fy" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************93*********************************************
   if (var_name.eq."fz") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "upward_eliassen_palm_flux" ;
      var@long_name ="fz" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************94*********************************************
   if (var_name.eq."accel_divf") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_eastward_wind_due _to_eliassen_palm_flux_divergence" ;
      var@long_name ="accel_divf" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************95*********************************************
   if (var_name.eq."vstar") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "northward_transformed_eulerian_mean_velocity" ;
      var@long_name ="vstar" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************96*********************************************
   if (var_name.eq."wstar") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "upward_transformed_eulerian_mean_velocity" ;
      var@long_name ="wstar" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************97*********************************************
   if (var_name.eq."accel_gw") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_eastward_wind_due_to_gravity_wave_drag" ;
      var@long_name ="accel_gw" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************98*********************************************
   if (var_name.eq."accel_ogw") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_eastward_wind_due_to_orographic_gravity_wave_drag" ;
      var@long_name ="accel_ogw" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************99*********************************************
   if (var_name.eq."ogw_flux") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "upward_flux_of_eastward_momentum_due_to_orographic_gravity_wave_drag" ;
      var@long_name ="ogw_flux" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************100*********************************************
   if (var_name.eq."accel_nogw") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_eastward_wind_due_to_nonorographic_gravity_wave_drag" ;
      var@long_name ="accel_nogw" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************101*********************************************
   if (var_name.eq."nogw_e_flux") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "upward_flux_of_eastward_momentum_due_to_nonorographic_eastward_gravity_wave" ;
      var@long_name ="nogw_w_flux" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************102*********************************************
   if (var_name.eq."nogw_w_flux") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "upward_flux_of_westward_momentum_due_to_nonorographic_westward_gravity_wave" ;
      var@long_name ="nogw_w_flux" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************103*********************************************
 if (var_name.eq."nogw_e_flux") then ;           
;      var@comment="comment????"
;      var@reference="?"
            var@standard_name = "upward_flux_of_eastward_momentum_due_to_nonorographic_westward_gravity_wave" ;
            var@long_name ="nogw_e_flux" ;
            var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************103*********************************************
   if (var_name.eq."diab_drag") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_eastward_wind_due_to_numerical_artefacts" ;
      var@long_name ="diab_drag" ;
      var@units = "MKS" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************104*********************************************
   if (var_name.eq."burden_N2O") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_nitrous_oxide_mole_burden" ;
      var@long_name ="burden_N2O" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************105*********************************************
   if (var_name.eq."tburden_N2O") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_notrous_oxide_mole_burden" ;
      var@long_name="tn2O" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************106*********************************************
   if (var_name.eq."burden_CFCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_cfc11_mole_burden" ;
      var@long_name="burden_CFCl3" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************107*********************************************
   if (var_name.eq."tburden_CFCL3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_cfc11_mole_burden" ;
      var@long_name="tCFCl3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************108*********************************************
   if (var_name.eq."burden_CF2Cl2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_cfc12_mole_burden" ;
      var@long_name="burden_CF2Cl2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************109*********************************************
   if (var_name.eq."tburden_CF2Cl2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_cfc12_mole_burden" ;
      var@long_name="tCF2Cl2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************110*********************************************
   if (var_name.eq."burden_CCl2FCClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_cfcl113_mole_burden" ;
      var@long_name="burden_CCl2FCClF2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************111*********************************************
   if (var_name.eq."tburden_CCl2FCClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_cfc12_mole_burden" ;
      var@long_name="tCF2Cl2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************112*********************************************
   if (var_name.eq."burden_CClF2CClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_cfcl114_mole_burden" ;
      var@long_name="burden_CClF2CClF2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************113*********************************************
   if (var_name.eq."tburden_CClF2CClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_cfc114_mole_burden" ;
      var@long_name="tCClF2CClF2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************114*********************************************
   if (var_name.eq."burden_CClF2CF3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_cfcl115_mole_burden" ;
      var@long_name="burden_CClF2CF3" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************115*********************************************
   if (var_name.eq."tburden_CClF2CF3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_cfc115_mole_burden" ;
      var@long_name="tCClF2CF3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************116*********************************************
   if (var_name.eq."burden_CCl4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_carbon_tetrachloride_mole_burden" ;
      var@long_name="burden_CCl4" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************117*********************************************
   if (var_name.eq."tburden_CCl4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_carbon_tetrachloride_mole_burden" ;
      var@long_name="tCCl4" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************118*********************************************
   if (var_name.eq."burden_CBrF3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_halon301_mole_burden" ;
      var@long_name="burden_CBrF3" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************119*********************************************
   if (var_name.eq."tburden_CBrF3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_halon301_mole_burden" ;
      var@long_name="tCBrF3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if


;*************************120*********************************************
   if (var_name.eq."burden_CBrClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_halon211_mole_burden" ;
      var@long_name="burden_CBrClF2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************121*********************************************
   if (var_name.eq."tburden_CBrClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_halon301_mole_burden" ;
      var@long_name="tCBrClF2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************122*********************************************
   if (var_name.eq."burden_C2Br2F4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_halon2402_mole_burden" ;
      var@long_name="burden_C2Br2F4" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************123*********************************************
   if (var_name.eq."tburden_C2Br2F4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_halon2402_mole_burden" ;
      var@long_name="tC2Br2F4" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************124*********************************************
   if (var_name.eq."burden_CBr2F2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_halon202_mole_burden" ;
      var@long_name="burden_CBr2F2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************125*********************************************
   if (var_name.eq."tburden_CBr2F2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_halon202_mole_burden" ;
      var@long_name="tCBr2F2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************126*********************************************
   if (var_name.eq."burden_CH4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_methan_mole_burden" ;
      var@long_name="burden_CH4" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************127*********************************************
   if (var_name.eq."tburden_CH4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_methan_mole_burden" ;
      var@long_name="tCH4" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************128*********************************************
   if (var_name.eq."tburden_ltr_CH4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_methan_mole_burden" ;
      var@long_name="tlrt_CH4" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************129*********************************************
   if (var_name.eq."tburden_lsm_CH4") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_methan_mole_burden" ;
      var@long_name="tlsm_CH4" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************130*********************************************
   if (var_name.eq."burden_CO") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_carbon_monoxide_mole_burden" ;
      var@long_name="burden_CO" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************131*********************************************
   if (var_name.eq."tburden_CO") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_carbon_monoxide_mole_burden" ;
      var@long_name="tCO" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************132*********************************************
   if (var_name.eq."t_burden_ltr_CO") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_carbon_monoxide_mole_burden" ;
      var@long_name="tlrt_CO" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************133*********************************************
   if (var_name.eq."tburden_lsm_CO") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_carbon_monoxide_mole_burden" ;
      var@long_name="tlsm_CO" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************134*********************************************
   if (var_name.eq."burden_H2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_hydrogen_mole_burden" ;
      var@long_name="burden_H2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************135*********************************************
   if (var_name.eq."tburden_H2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_hydrogen_mole_burden" ;
      var@long_name="tH2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************136*********************************************
   if (var_name.eq."tburden_ltr_H2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_hydrogen_mole_burden" ;
      var@long_name="tlrt_H2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************137*********************************************
   if (var_name.eq."tburden_lsm_H2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_hydrogen_mole_burden" ;
      var@long_name="tlsm_H2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************138*********************************************
   if (var_name.eq."burden_CH3Cl") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_methyl_chloride_mole_burden" ;
      var@long_name="burden_CH3Cl" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************139*********************************************
   if (var_name.eq."tCHCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_methyl_chloride_mole_burden" ;
      var@long_name="tCH3Cl" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************140*********************************************
   if (var_name.eq."tburden_ltr_CH3Cl") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_methyl_chloride_mole_burden" ;
      var@long_name="tlrt_CH3Cl" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************141*********************************************
   if (var_name.eq."tburden_lsm_CH3Cl") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_methyl_chloride_mole_burden" ;
      var@long_name="tlsm_CH3Cl" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************142*********************************************
   if (var_name.eq."burden_CH3Br") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_methyl_bromide_mole_burden" ;
      var@long_name="burden_CH3Br" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************143*********************************************
   if (var_name.eq."tburden_CH3Br") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_methyl_bromide_mole_burden" ;
      var@long_name="tCH3Br" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************144*********************************************
   if (var_name.eq."tburden_ltr_CH3Br") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_methyl_bromide_mole_burden" ;
      var@long_name="tlrt_CH3Br" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************145*********************************************
   if (var_name.eq."tburden_lsm_CH3Br") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_methyl_chloride_mole_burden" ;
      var@long_name="tlsm_CH3Br" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************146*********************************************
   if (var_name.eq."burden_CH3CCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_hcc140a_mole_burden" ;
      var@long_name="burden_CH3CCl3" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************147*********************************************
   if (var_name.eq."tburden_CH3CCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_hcc140a_mole_burden" ;
      var@long_name="tCH3CCl3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************148*********************************************
   if (var_name.eq."tburden_ltr_CH3CCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_hcc140a_mole_burden" ;
      var@long_name="tlrt_CH3CCl3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************149*********************************************
   if (var_name.eq."tburden_lsm_CH3CCl3") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_middle_atmosphere_hcc140a_mole_burden" ;
      var@long_name="tlsm_CH3CCl3" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************150*********************************************
   if (var_name.eq."burden_CHClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "atmosphere_hcfc22_mole_burden" ;
      var@long_name="burden_CHClF2" ;
      var@units = "molecules" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************151*********************************************
   if (var_name.eq."tburden_CHClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_atmosphere_hcfc22_mole_burden" ;
      var@long_name="tCHClF2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************152*********************************************
   if (var_name.eq."tburden_ltr_CHClF2") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "tendency_of_troposphere_hcfc22_mole_burden" ;
      var@long_name="tlrt_CHClF2" ;
      var@units = "molecules/yr" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;***************************153**********************************************
   if (var_name.eq."sad_sulf") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "particle_surface_area_density_of_sulfate_aerosol" ;
      var@long_name="sad_sulf" ;
      var@units = "10^(-6) m ^(-1)" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;***************************154**********************************************
   if (var_name.eq."sad_nat") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "particle_surface_area_density_of_nitric_acid_trihydate";
      var@long_name="sad_nat" ;
      var@units = "10^(-6) m ^(-1)" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;***************************155**********************************************
   if (var_name.eq."sad_ice") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "particle_surface_area_density_of_water_ice";
      var@long_name="sad_ice" ;
      var@units = "10^(-6) m ^(-1)" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************156*********************************************
   if (var_name.eq."psca_nh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "arctic_area_integral_of_polar_stratospheric_cloud_area_fraction" ;
      var@long_name="PSCA NH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************157*********************************************
   if (var_name.eq."psca_sh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "antarctic_area_integral_of_polar_stratospheric_cloud_area_fraction" ;
      var@long_name="PSCA SH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************158*********************************************
   if (var_name.eq."area188K_nh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "arctic_area_where_air_temperature_less_than_188K" ;
      var@long_name="Area Temperature below 188 NH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************159*********************************************
   if (var_name.eq."area195K_nh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "arctic_area_where_air_temperature_less_than_195K" ;
      var@long_name="Area Temperature below 195 NH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************160*********************************************
   if (var_name.eq."area188K_sh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "antarctic_area_where_air_temperature_less_than_188K" ;
      var@long_name="Area Temperature below 188 SH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

;*************************161*********************************************
   if (var_name.eq."area195K_sh50") then ;
;      var@comment="comment????"
;      var@reference="?"
      var@standard_name = "antarctic_area_where_air_temperature_less_than_195K" ;
      var@long_name="Area Temperature below 195 SH" ;
      var@units = "m^2" ;
      var@_FillValue = 1.0* 10^(20) ;
;      var@missing_value = 1.0* 10^(20) ;
   end if

   var = var

;caf print(var@_FillValue)
;caf print(min(var))
;caf print(max(var))

   return(var)

end
