;_______________________________________________________________________________
;      function coord_list(coord_name:string; coord:numeric)
;_______________________________________________________________________________
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
undef("coord_list")
function coord_list( coord_name:string,coord:numeric)
local coord,coord_name
begin
   coord=coord

;**************PRESSURE*********************************
   if (coord_name.eq."plev") then
      coord@axis = "Z" ;
      coord@positive="down"
      coord@standard_name = "air_pressure" ;
      coord@units = "hPa" ;
      coord@long_name = "Pressure" ;

      delete (coord@_FillValue)
   end if

;*************SIGMA LEVEL*********************************
   if (coord_name.eq."lev") then
      coord@formula_terms= "a: hyam b: hybm p0: P0 ps: PS"
      coord@axis = "Z" ;
      coord@positive="down"
      coord@standard_name = "atmosphere_sigma_coordinate" ;
      coord@long_name = "hybrid level at midpoints (1000*(A+B))"  ;

      delete (coord@_FillValue)
   end if

;**************LATITUDE***********************************
   if (coord_name.eq."lat") then
      coord@axis="Y"
      coord@standard_name = "latitude" ;
      coord@units = "degrees_north" ;
      coord@long_name = "Latitude"

      delete (coord@_FillValue)
   end if

;**************LONGITUDE***********************************
   if (coord_name.eq."lon") then
      coord@axis = "X"
      coord@standard_name = "longitude" ;
      coord@units = "degrees_east" ;
      coord@long_name = "Longitude" ;

      delete (coord@_FillValue)
   end if

;***************TIME***************************************
   if (coord_name.eq."time") then
;caf     printVarSummary(coord)
      coord@axis = "T" ;
      if (.not.isatt(coord,"calendar")) then
         coord@calendar ="standard"
      end if
      coord@standard_name = "time" ;
      coord@units = "days since 1950-01-01 00:00:00"
      coord@long_name = "time"

      delete (coord@_FillValue)
   end if

   coord=coord
   return(coord)

end
