; From read_data.ncl
;++AG fix calendars here
;   if(models@name(i).eq."MRI") then
;   if (.not.isatt(data&time,"calendar")) then
;      data&time@calendar="365_day"
;   end if
;    end if
;--AG

; MRI lon = [2.8125,..,360.0]. Re-arrange data to have lon=[0.0,..,357.1875]

undef("fix_data")
function fix_data(dataX)
begin
   if (.not.isatt(dataX&time,"calendar")) then
      ;dataX&time@calendar="365_day"
      dataX&time@calendar="standard"
   end if

   if isdim(dataX,"lon") then
      dumLon = dataX&lon
      if (dumLon(0).ne.0.0) .and. (dumLon(dimsizes(dumLon)-1).eq. 360.0) then
         rank = dimsizes(dimsizes(dataX))
         result = dataX
         if (rank.eq.4) then
            result(:,:,:,0) = dataX(:,:,:,dimsizes(dumLon)-1)
            result(:,:,:,1:dimsizes(dumLon)-1) = dataX(:,:,:,0:dimsizes(dumLon)-2)
         end if
         if (rank.eq.3) then
            result(:,:,0) = dataX(:,:,dimsizes(dumLon)-1)
            result(:,:,1:dimsizes(dumLon)-1) = dataX(:,:,0:dimsizes(dumLon)-2)
         end if
         delete(rank)
         result&lon(0) = 0.0
         result&lon(1:dimsizes(dumLon)-1) = dumLon(0:dimsizes(dumLon)-2)
         delete(dumLon)
         return(result)
      else
         delete(dumLon)
         return(dataX)
      end if
   else
      return(dataX)
   end if
end
