; From read_data.ncl
;AG
;    rank=dimsizes(dimsizes(data))
;   if (models@name(i).eq."UMUKCA-METO") then
;      if (rank.eq.4 .or. (rank.eq.3.and.(field_number.eq."T2Mz".or.field_number.eq."C2Mz"))) then
;         data!1 = "plev"
;         if (isinteger(data&plev)) then
;            data2=data
;            delete(data2&plev)
;            ;need to divide by 100 (convert to Pa) AND convert to float!
;            tmp = int2flt(data&plev) / 100.
;            data2!1 = "plev"
;            data2&plev = tmp
;            delete(tmp)
;            data2&plev@units ="hPa"
;            delete(data)
;            data=data2
;         end if
;         if (max(data&plev).gt.2000.) then
;            data&plev=data&plev/100.
;         end if
;      end if
;   end if
;--AG

; From climate.ncl
;++CAF
; if (mname.eq."UMUKCA-METO") then
;   data!1 = "plev"
;   print(data&plev)
;   temp=data
;   delete(data)
;   data=temp(:,::-1,:,0)
;   delete(temp)
;   print(data&plev)
; end if
;--CAF

; From cf_convert.py
;  elif (m.name == "UMUKCA-METO"):
;    environ["lat_name"]="lat"
;    environ["lon_name"]="lon"
;    environ["lev_name"]="level"
;    environ["time_name"]="time"

lev_name="level"

undef("fix_data")
function fix_data(dataX)
begin
   rank = dimsizes(dimsizes(dataX))
   field = getenv ("CCMVal_field")
   if ((rank.eq.4) .or. ((rank.eq.3).and.(isStrSubset(field,"z")))) then
      dataX!1 = lev_name 
      ; Convert to float!
      if (isinteger(dataX&$lev_name$)) then
         plev_flt = int2flt(dataX&$lev_name$)
         delete(dataX&$lev_name$)
         dataX&$lev_name$ = plev_flt
         delete(plev_flt)
      end if
      ; Need to divide by 100 (convert to hPa)
      if (max(dataX&$lev_name$).gt.2000.) then
         dataX&$lev_name$ = dataX&$lev_name$ / 100.
         dataX&$lev_name$@units ="hPa"
      end if
      ; Reverse the order...
      if (dataX&$lev_name$(0).lt.dataX&$lev_name$(1)) then
         if (rank.eq.4) then
            dataX = dataX(:,::-1,:,:)
         end if
         if (rank.eq.3) then
            dataX = dataX(:,::-1,:)
         end if
      end if
   end if
   return(dataX)
end
