;*********************************************************************
; test_timerange.ncl
; 2012-05-10   HS  check dimension size of time for monthly file
;                  which is created by attribute.ncl.
;                  if mod(dimsizes(time),12) <> 0 then fill the gap(s)
;                  with _FillValue.
;*********************************************************************

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

; get environment variables
   fields_mm = (/"T2Ms","T3M","T2Mz","T1Ms"/)
   field = getenv ("CCMVal_field")
   dur   = getenv ("outputdir")
   fol   = getenv ("outputfile")

; check field of input-file
   fn_in = dur+fol
   if (.not.isfilepresent(fn_in)) then
      exit
   end if

; check field of input-file
   idx_field = ind(fields_mm.eq.field)
   if (.not.ismissing(idx_field)) then

      fin = addfile(fn_in,"r")
      ftime = fin->time

      ntim = dimsizes(ftime)
      nmos = 12
      if (mod(ntim,nmos).ne.0) then

         print("[test_timerange.ncl] "+fn_in)

         var_name = getenv ("var_name")
         vards = getfilevardimsizes(fin,var_name)
         rank = dimsizes(vards)

         ;============================================================
         ; step1: create output file
         ;============================================================
         fn_out = dur + "tempfile_time.nc"
         fout = addfile(fn_out,"c")
         ; make time and UNLIMITED dimension
         filedimdef(fout,"time",-1,True)

         first_write = True
         file_pointer = 0

         ;============================================================
         ; step2: find out start and end years -> nyears
         ;============================================================
         ftimeYYYYMMDD = ut_calendar(ftime,-2)
         ftimeYYYYMM = ftimeYYYYMMDD/100
         stYear = ftimeYYYYMMDD(0)/10000
         edYear = ftimeYYYYMMDD(ntim-1)/10000
         DD = ftimeYYYYMMDD(0) - ftimeYYYYMM(0) * 100

         ;============================================================
         ; step3: loop through file yearly and read into array VOUT
         ;============================================================
         ; find out dimension sizes for output
         dout = vards
         dout(0) = 12

         do i=stYear,edYear
            curYr = i * 100
            idx_time = ind(abs(ftimeYYYYMM-curYr).le.nmos)
            if (.not.(all(ismissing(idx_time)))) then
                vout = new(dout,"float")

               ; calculate index of time exists
               idx_out = (ftimeYYYYMM(idx_time)-curYr)-1

               ; get a block of data
               if (rank.eq.4) then
                  vout(idx_out,:,:,:) = fin->$var_name$(idx_time,:,:,:)
               end if
               if (rank.eq.3) then
                  vout(idx_out,:,:) = fin->$var_name$(idx_time,:,:)
               end if
               if (rank.eq.2) then
                  vout(idx_out,:) = fin->$var_name$(idx_time,:)
               end if
               if (rank.eq.1) then
                  vout(idx_out) = fin->$var_name$(idx_time)
               end if
               if (dimsizes(idx_time).eq.12) then
                  tout = ftime(idx_time)
               else
                  tout = new(nmos,"float")
                  k = 0
                  do j=0,11
                     if (ismissing(ind(idx_out.eq.j))) then
                        tout(j) = doubletofloat(ut_inv_calendar(i,(j+1),DD,0,0,0,ftime@units,0))
                        print("Adding missing month: "+i+"/"+sprinti("%0.2i",(j+1))+"/"+sprinti("%0.2i",DD))
                     else
                        tout(j) = ftime(idx_time(k))
                        k = k + 1
                     end if
                  end do
               end if
               vout&time = (/tout/)

               ;======================================================
               ; step4: write to output file, fout
               ;======================================================
               if first_write then

                  fout->$var_name$ = vout
                  first_write = False

               else

                  end_point = file_pointer+nmos-1

                  fout->time(file_pointer:end_point)=(/vout&time/)

                  if (rank.eq.4) then
                     fout->$var_name$(file_pointer:end_point,:,:,:) = (/vout/)
                  end if
                  if (rank.eq.3) then
                     fout->$var_name$(file_pointer:end_point,:,:) = (/vout/)
                  end if
                  if (rank.eq.2) then
                     fout->$var_name$(file_pointer:end_point,:) = (/vout/)
                  end if
                  if (rank.eq.1) then
                     fout->$var_name$(file_pointer:end_point) = (/vout/)
                  end if
               end if
               file_pointer = file_pointer + nmos

               delete(vout)
               delete(idx_out)
            end if
            delete(idx_time)
         end do

         ; copy global attributes

         file_atts = getvaratts(fin)
         if(.not.all(ismissing(file_atts))) then
            do i = 0,dimsizes(file_atts)-1
               fout@$file_atts(i)$ = fin@$file_atts(i)$
            end do
         end if
         delete(file_atts)

         ; copy other variables if exist

         vNames = getfilevarnames(fin)
         if (dimsizes(vNames).gt.(rank+1)) then
            dNames = getfilevardims(fin,var_name)
            usedVars = new(dimsizes(dNames)+1,"string")
            usedVars(0) = var_name
            usedVars(1:dimsizes(dNames)) = dNames
            delete(dNames)
            do i = 0,dimsizes(vNames)-1
               idx_var = ind(usedVars.eq.vNames(i))
               if (ismissing(idx_var)) then
                  fout->$vNames(i)$ = fin->$vNames(i)$
               end if
               delete(idx_var)
            end do
            delete(usedVars)
         end if
         delete(vNames)

         delete(var_name)
         delete(vards)
         delete(rank)
         delete(ftimeYYYYMMDD)
         delete(ftimeYYYYMM)
         delete(stYear)
         delete(edYear)
         delete(DD)
         delete(dout)

         ; copy result back to orignal file     
         delete(fout)
         system("mv "+fn_out+" "+fn_in)
         delete(fn_out)

      end if
      delete(ntim)
      delete(fin)
      delete(ftime)
      delete(dur)
      delete(fol)

   end if
   delete(idx_field)
   delete(fn_in)

end

