#!/usr/bin/python

# Sanity checks for model files
# M. Neish - 2008/06/02

# Dependencies:  requires a "model" class from the namelist reader

from namelist import *
#from os import listdir

# Get the range of years for a CF-compliant netcdf file
def get_years(filename, debug=false):
#  from Scientific.IO import NetCDF
  import ncquick
  from re import match
  from datetime import date, timedelta
  if debug == true: print 'Getting time range of', filename
#  file = NetCDF.NetCDFFile (filename, 'r')
  file = ncquick.open (filename)
#  time = file.variables['time']
  time = file.var('time')

#  calendar = getattr(time, 'calendar')
  calendar = time.att('calendar')

#  units = getattr(time, 'units')
  units = time.att('units')

  time = time.values()

  # Get the reference year
  ref_date = match('days since (\d{4})-(\d{1,2})-(\d{1,2}).*',units)
#  ref_date = date(*(int(i) for i in ref_date.groups()))
# changed for compatiblity with older versions of Python
  ref_date = date(int(ref_date.group(1)), int(ref_date.group(2)), int(ref_date.group(3)))
  # Case 1: 365-day calendar (no leap years)
  if calendar in ('noleap', '365_day'):
    return [ref_date.year + int(time[i]/365) for i in (0,-1)]
  # Case 2: standard calendar
  elif calendar in ('standard'):
    return [(ref_date + timedelta(int(time[i]))).year for i in (0,-1)]
  else:
    print 'Error: invalid calendar type for', filename
    exit(1)
#  file.close()
  ncquick.close(file)

def sanity_check (namelist):
  from os.path import isdir
  from glob import glob
  from re import match, search, compile
  debug=namelist.global_vars.debug

  project='CCMVal2'

  # Loop over all model cases in the namelist
  # Note: looping over a *copy* of the list, since we are modifying the
  #       original inside the loop!
  for m in namelist.models[:]:
    if debug: print 'checking', m
    # Check the model directory
    if not isdir(m.dir):
      print 'Warning: directory', m.dir, 'does not exist!'
      print 'Ignoring', m
      namelist.models.remove(m)
      continue
    # Check for matching files
    prefix=project+'_'+m.case+'_'+m.name+'_'+m.ensemble
    files=glob(m.dir+'/'+prefix+'*.nc')
    if len(files) == 0:
      print "Warning: no matches found in '"+m.dir+"'"
      print 'Ignoring', m
      namelist.models.remove(m)
      continue
    # Store the matching files for future use
    m.files = files
    # Check the files for the requested years
    for file in m.files[:]:
      [start_year, end_year] = get_years(file, debug=debug)
      if int(m.start_date) < start_year or int(m.end_date) > end_year:
        print "Warning: selected dates (",m.start_date,"-",m.end_date,") ",
        print "do not fall within the dates in the file ",
        print "(",start_year,"-",end_year,")"
        print "Ignoring", file
        m.files.remove(file)
        continue
    # Check if we have any files left
    if len(m.files) == 0:
      print "Warning: No files left for",m," -- ignoring this model entry"
      namelist.models.remove(m)
      continue
    # Get field types & variables for the files
    c = compile(prefix+'_([^_]+)_(.*).nc')
    [m.fields,m.vars] = [[c.search(f).group(i) for f in m.files] for i in (1,2)]
    [m.fields,m.vars] = [[c.search(f).group(i) for f in m.files] for i in (1,2)]
#    print "1:", [ c.search(f).group(1) for f in m.files]
#    print "2:", [ c.search(f).group(2) for f in m.files]
  # Check if there is anything left to do!
  if len(namelist.models) == 0:
    print "Error: Nothing left to do!"
    exit(1)
  if debug == true:
    print "model entries that we are using:"
    for m in namelist.models:
      print m


# Check if we're running from the command line
# (useful for testing this module)
if __name__ == '__main__':
  from sys import argv
  if len(argv) == 1:
    print 'Purpose: check the entries in the namelist for errors'
    print '(i.e. missing files/directories, invalid dates, etc.)'
    print 'Usage: ', argv[0], '[namelist]'
    exit (1)
  namelist = read_namelist(argv[1], debug=true)
  sanity_check (namelist)
  print "Finished with no critical errors"
