;
;  Requires: vorpot840:*2*s
;
info = True
info@derived = True
info@long_name="Equivalent_latitude_of_vorpot840"
info@units="degrees"
;load "./ncl_code/function_eq_lat.ncl"
;load "./plot_type/uniform_coordinates.ncl"
load "./ncl_code/CalcEqLat.ncl"

undef("calculate")
function calculate(models,variable,field_number)
local tmp, dum, data, i
begin
  data_new = True

  tmp = read_data(models,"vorpot840","*2*s")
  do i=0,dimsizes(models@name)-1
    dum = extract_data(models,tmp,i,-1,0,0)
    data=CalcEqLat(dum,"T2Ds")
    data@long_name=info@long_name
    add_data(models,data_new,data,i)
    delete(dum)
    delete(data)
  end do
  delete(tmp)

  return(data_new)
end


