;
; Requires: none
;
info = True
info@derived = True
info@long_name = "HCl"
info@units = "ppbv"

info@fig05_yr_min = 1980
info@fig05_yr_max = 1999
info@fig05_lat_sel = (/80.,0.,-80./)
info@fig05_month_lat_sel = (/"APR","APR","NOV"/)
info@fig05_lev_sel = (/50.,50./)
info@fig05_month_lev_sel = (/"APR","NOV"/)
info@fig05_obs_name = (/"HALOE"/)
;info@fig05_refModel=(/"UMETRAC"/)
info@fig05_obs_file = "./plot_type/input_data/OBS/haloe_lat_climat.nc"
info@fig05_obs_stdv_file = "./plot_type/input_data/OBS/haloe_lat_climat.nc"

undef("calculate")
function calculate(models,variable,field_number)
local hcl
; convert mol/mol to ppbv
begin
  result = read_data(models,variable,field_number)
  do i=0,dimsizes(models@name)-1
    hcl = extract_data(models,result,i,-1,0,0)
    hcl = (/hcl*1e9/)       ; convert to ppb
    hcl@units = info@units
    if (typeof(hcl).eq."double") then
      hcl_flt = dble2flt(hcl)
    else
      hcl_flt = hcl
    end if
    modify_data(models,result,hcl_flt,i)
    delete(hcl)
    delete(hcl_flt)
  end do

  return(result)
end
