;
; Requires: ta:*2*
;
info = True
info@derived = True   
;OLD Requires: ta:T2*
;info@derived = False 
info@long_name="Tropopause Air Pressure"
info@units="hPa"

info@scp_cnlvl=(/50,150,200,250,300,350,400,450,500,550,600/) ; ptp
info@scp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@pcp_cnlvl=(/50,150,200,250,300,350,400,450,500,550,600/) ; ptp
info@pcp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@sdp_cnlvl=(/50,150,200,250,300,350,400,450,500,550,600/) ; ptp
info@acp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@refModel = "CMAM"

info@vcp_ptop=6e-6
info@vcp_LogScale = True
info@rgb_file = "amwg.rgb"

info@ts_latrange = (/-20,20/)
info@ts_lonrange = (/0,360/)
info@ts_anom = True
info@ts_multimean = True
info@ts_smooth = True

info@ml_latrange = (/-20,-20/)
info@ml_lonrange = (/0,360/)
info@ml_anom = False

;surfcontrend: surface contour trend plots
info@sct_cnlvl= (/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)*2.e-2
info@sct_dcnlvl= (/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)*2.e-2

info@fig07_lat_min = (/-10./)
info@fig07_lat_max = (/10./)
info@fig07_lev_sel = (/80./)


undef("calculate")
function calculate(models,variable,field_number)
local result, i, pr, T, pin, tin, ptp, lt, latout, ltN, tdatN, \
      lttmpN, knots, xlat, ltS, tdatS, lttmpS, t
begin
  data_new=True
  result = read_data(models,"ta","*2Mz")
;  missing=-999.0
  do i=0,dimsizes(models@name)-1
    print(models@name(i))
    T = extract_data(models,result,i,-1,0,0)

;    printVarSummary(T)
;    print(max(T))
;    print(min(T))

;exit

;    dims=dimsizes(T)
;    ptp=new((/dims(0),dims(2),dims(3)/),"float")

;check ordering....needs to be top to bottom (lowest pressure first)

    pr=T&plev
    if (pr(0).eq.max(pr)) then
	pin =  pr(::-1)
	tin =  T({time | :},{lat | :},{plev | ::-1})
    else
	pin = pr
	tin = T({time | :},{lat | :},{plev | :})
    end if	 

    if(max(pin).gt.2000.) then
	pin=pin/100.
    end if

;print(pin)
;printVarSummary(tin)
;print(max(tin))
;print(min(tin))
;exit

     ptp = trop_wmo(pin, tin, 0, False)

; original that did not check for ordering
;    ptp = trop_wmo(pr(::-1), T({time | :},{lat | :},{lon | :},{plev | ::-1}), 0, False) 
 
     delete(pin)
     delete(tin)

;   for outputing altitude (km) instead
;    ztp = -7.500*log(ptp/1013.)

    ptp!0=T!0
    ptp!1=T!2
;    ptp!2=T!3
    ptp&time=T&time
    ptp&lat=T&lat
;    ptp&lon=T&lon
    
;    ptp@_FillValue = T@_FillValue
    ptp@_FillValue = -999.

    printVarSummary(ptp)
    print(max(ptp))
    print(min(ptp))

;exit

    ptp@long_name=info@long_name
    ptp@units=info@units
    add_data(models,data_new,ptp,i)
    delete(T)
    delete(ptp)
    delete(pr)

  end do

  c=stringtochar(field_number)
  c(1)=integertochar(50) ; "2"
  c(3)=integertochar(115) ; "s"
  field_number=chartostring(c)
  print(field_number)
  delete(c)
  return(data_new)
end

