;
;  Requires: ua:*3*
;
info = True
info@derived = True
info@long_name="eastward_wind"
info@units="m s-1"
info@scp_cnlvl=(/-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80/) 
info@pcp_cnlvl=(/-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80/)
info@scp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@pcp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@sdp_cnlvl = (/-30,-25,-20,-15,-10,-5,-2,0,2,5,10,15,20,25,30/)
info@acp_cnlvl=(/-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80/)
info@acp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@sct_cnlvl=(/-80,-70,-60,-50,-40,-30,-20,-10,10,20,30,40,50,60,70,80/) 
info@sct_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@seasons = (/"ANN","DJF","MAM","JJA","SON"/)
info@regions = (/"GLBL"/)
info@refModel = "WACCM"

info@vcp_ptop=6e-6
info@vcp_LogScale = True
info@rgb_file = "amwg.rgb"


undef("calculate")
function calculate(models,variable,field_number)
local tmp, dum, i
begin
  data_new = True
  tmp = read_data(models,"ua","*3*")
  do i=0,dimsizes(models@name)-1
    dum = extract_data(models,tmp,i,1,100.,100.)   ;extract_data(models,tmp,i,"plev",100.,100.)

    dum@long_name=info@long_name
    dum@units=info@units
    add_data(models,data_new,dum,i)

    delete(dum)
  end do
  delete(tmp)

  return(data_new)
end
