;
;  Requires: ua:*3*
;
info = True
info@derived = True
info@long_name="200mb Zonal Wind"
info@units="m/s"
info@scp_cnlvl = (/-20,-15,-10,-5,0,5,10,15,20,25,30,40,50,60,70/) ; U at 200
info@scp_dcnlvl = (/-28,-24,-20,-16,-12,-8,-4,0,4,8,12,16,20,24,28/)
info@acp_cnlvl = (/-25,-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45/) ; U at 200
info@acp_dcnlvl = (/-12,-10,-8,-6,-4,-2,-1,0,1,2,4,6,8,10,12/) ; U at 200
info@sdp_cnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@pcp_cnlvl=(/-20,-15,-10,-5,0,5,10,15,20,25,30,40,50,60,70/) ; U(ua)
info@pcp_dcnlvl=(/-18,-15,-12,-9,-6,-3,-1,0,1,3,6,9,12,15,18/)
info@rgb_file = "amwg.rgb" ;"red-blue.rgb"
;info@refModel = "UMETRAC"
info@refModel = "SOCOL"


undef("calculate")
function calculate(models,variable,field_number)
local tmp, dum, i
begin
  data_new = True
  tmp = read_data(models,"ua","*3*")
  do i=0,dimsizes(models@name)-1
    dum = extract_data(models,tmp,i,1,200.,200.)   ;extract_data(models,tmp,i,"plev",200.,200.)

    dum@long_name=info@long_name
    dum@units=info@units
    add_data(models,data_new,dum,i)

    delete(dum)
  end do
  delete(tmp)

  return(data_new)
end
